# MVP Traps and Anti-Patterns

## The False MVP

**Symptoms:**
- Took 6+ months to build
- Zero users touched it during development
- Founder calls it "MVP" but it has 20+ features
- "We're almost ready to launch" for months

**Reality:** It's not an MVP. It's a full product built on assumptions.

**Fix:** Strip it down. What's the ONE feature that tests your hypothesis? Launch that this week.

---

## Building ≠ Learning

**The trap:** "We shipped! Success!"

**Reality:** Shipping is not the goal. Learning is.

**Questions after launch:**
- What did we learn?
- What assumption did we validate or invalidate?
- What changes based on this?

If you can't answer these, the MVP failed regardless of how polished it is.

---

## The Polish Trap

**Symptoms:**
- "Just one more week to clean up the UI"
- "We can't launch until the onboarding is smooth"
- "Users will think we're unprofessional"

**Reality:** Users at MVP stage expect rough edges. They're early adopters, not mainstream buyers.

**Rule:** If it embarrasses you a little, it's probably ready.

---

## Over-Engineering

**Symptoms:**
- Microservices architecture for 0 users
- 100% test coverage on unvalidated features
- "We built it to scale to 1M users"
- Weeks spent on infrastructure, not features

**Reality:** You're avoiding the scary part (showing it to users) by staying in the comfortable part (writing code).

**Fix:** Ask "What's the simplest thing that could work?" then build that.

---

## Scope Creep Disguised as "Must-Haves"

**How it sounds:**
- "We can't launch without admin panel"
- "Users will expect dark mode"
- "Competitors have real-time updates"

**How to challenge it:**
- "Would you delay launch 2 weeks for this?"
- "What if we launched without it and added it in v2?"
- "How many users asked for this?"

**Rule:** If the answer is "nobody asked, but they'll expect it," it's not a must-have.

---

## The Zombie MVP

**Symptoms:**
- Launched months ago
- Few users, low engagement
- No significant changes since launch
- Founder keeps "iterating" without results

**Reality:** The MVP answered the question. The answer was "no." Time to kill it or pivot dramatically.

**Kill criteria:** If after 4 weeks of active iteration you can't move key metrics, the hypothesis is invalid.

---

## Building for Investors, Not Users

**Symptoms:**
- "Investors want to see traction"
- "We need these features for the demo"
- "The pitch deck says we do X"

**Reality:** Investors invest in traction. Traction comes from users. Build for users, investors follow.

**Rule:** If a feature exists only for demos, cut it.

---

## The Research Trap

**Symptoms:**
- "We need more user interviews"
- "Let's do another survey"
- "I'm not sure we understand the market yet"

**Reality:** After 20+ interviews, more research is procrastination. You have enough to build something.

**Rule:** Research until you can state your hypothesis clearly. Then build and test.

---

## The Perfect Launch Trap

**Symptoms:**
- Coordinating PR, social, Product Hunt simultaneously
- Waiting for "the right moment"
- Building launch hype before product exists

**Reality:** Most MVPs shouldn't launch big. They should launch small, learn, iterate, THEN launch big when they have something that works.

**Better:** Soft launch to 50 people. Learn. Fix. Then decide if you want a big launch.
