# Solo Builder / Indie Hacker MVP Guide

You're doing everything alone. Your challenge is speed without burning out or building something nobody wants.

## The Solo MVP Formula

**Week 1:** Validate
- Landing page live (Carrd, Webflow, Notion)
- Post in 3 communities where your users hang out
- DM 10 people who might have the problem
- Goal: 50+ signups or clear "nobody cares" signal

**Week 2-3:** Build
- Ship the smallest thing that delivers value
- One feature. One user flow. That's it.
- Use boilerplates (auth, payments already done)

**Week 4:** Launch
- Product Hunt, Hacker News, relevant subreddits
- Personal outreach to everyone who signed up
- Goal: 10 real users using it

**Week 5+:** Iterate or Kill
- If no retention after 2 weeks of trying, kill it
- If some signal, iterate fast

## Tech Stack for Speed (2024)

| Need | Fastest Option |
|------|----------------|
| Landing page | Carrd ($19/yr) |
| Web app | Next.js + Supabase |
| Mobile | Flutter or React Native |
| Payments | Stripe Checkout (copy/paste) |
| Auth | Clerk, Supabase Auth, or Firebase Auth |
| Database | Supabase, PocketBase, or Firebase |
| Hosting | Vercel, Railway, Fly.io |

Don't debate tools. Pick one. Ship.

## Validation Without Audience

You don't have followers. That's fine.

**Where to find early users:**
- Reddit (find the subreddit, be helpful first)
- Indie Hackers (post build in public updates)
- Twitter/X (reply to people with the problem)
- Discord/Slack communities in your niche
- Cold DMs on LinkedIn (for B2B)

**What to say:**
> "Hey, I'm building [X] for people who [problem]. Would you try an early version and tell me what's broken?"

People help builders. Ask.

## Kill Criteria

Before building, define what failure looks like:

| Signal | Threshold | Action |
|--------|-----------|--------|
| Landing page signups | <50 in 2 weeks | Pivot or kill |
| Day 7 retention | <10% | Problem isn't painful enough |
| Paid conversion | 0 after 50 trials | Value prop unclear |

If you hit the threshold, be honest. Most ideas don't work. That's normal. The goal is to find out fast.

## Time Boxing

- Validation: 1 week max
- Build: 2 weeks max
- Launch: 1 day
- Iterate: 1 week cycles

If you're still building after a month with no users, you're procrastinating with code.
