# Product Manager MVP Guide

You manage scope, timelines, and competing priorities. Your challenge is holding the line while keeping stakeholders aligned.

## Scope Defense Toolkit

### The Tradeoff Template
When someone requests a feature, use this:

> "If we add [FEATURE], we either:
> A) Cut [OTHER FEATURE], or
> B) Slip launch by [X WEEKS]
> Which do you prefer?"

Never accept scope additions without explicit tradeoffs.

### Decision Log
Keep a running document:

| Date | Request | Decision | Rationale | Owner |
|------|---------|----------|-----------|-------|
| 2/10 | Add export to CSV | Moved to v2 | Not needed to test core hypothesis | Sarah |

This prevents re-litigation. Point people to the log.

## Stakeholder Alignment

**Different people hear different things:**

| When you say "MVP" | CEO hears | Engineering hears | Design hears |
|--------------------|-----------|-------------------|--------------|
| Minimum | Embarrassing | Technical debt | Ugly |
| Viable | Revenue | Working code | Functional |
| Product | Competitor-ready | Shipped | Polished |

**Fix this in kickoff.** Get explicit agreement on:
1. What's IN scope (list of 3-5 features)
2. What's OUT of scope (explicit, written)
3. What "done" means (specific criteria)
4. Ship date (non-negotiable)

## Feature Prioritization

Use MoSCoW with time-boxing:

| Priority | Meaning | Rule |
|----------|---------|------|
| **Must** | MVP fails without it | Max 3 features |
| **Should** | Important, not critical | Only if time allows |
| **Could** | Nice to have | v2 |
| **Won't** | Out of scope | Document why |

If someone argues a "Should" is really a "Must," ask:
> "Would you delay launch by 2 weeks for this?"

## Launch Criteria Checklist

- [ ] All "Must" features complete
- [ ] One user can complete core flow unassisted
- [ ] Success metrics defined and trackable
- [ ] Stakeholders signed off on scope doc
- [ ] Launch date communicated externally

## When Scope Creeps

Symptoms:
- "While we're at it..."
- "This will only take a day"
- "Users will expect..."

Response:
1. Acknowledge the value
2. Add to backlog (visible)
3. Restate tradeoff
4. Require explicit decision from owner
