# Non-Technical Founder MVP Guide

You have vision and domain expertise. Your challenge is translating that into something buildable without overspending.

## Before Hiring a Developer

**Validate WITHOUT code first:**
1. Landing page with email signup (Carrd, Webflow)
2. Manual "Wizard of Oz" — you do the work behind the scenes
3. Concierge MVP — serve 5 customers manually to learn the flow
4. Pre-sell — can you get 10 people to pay before it exists?

If nobody signs up, pays, or responds, code won't fix that.

## Developer Communication Framework

**When describing what you want:**
- Focus on USER ACTIONS, not technical implementation
- "User uploads a photo and sees similar products" (good)
- "Use AI image recognition with vector embeddings" (bad — that's their job)

**Questions to ask:**
- "What's the simplest version that lets us test [hypothesis]?"
- "If we cut this feature, how much time do we save?"
- "What will break if we skip this?"
- "What's the risk if this works and we get 1000 users?"

**Red flags from developers:**
- Won't give time estimates ("it depends" without clarification)
- Wants to build for scale before you have users
- Dismisses your timeline without alternatives
- Can't explain decisions in business terms

## Budget Reality Check

| Approach | Cost | Timeline | Best For |
|----------|------|----------|----------|
| No-code (Bubble, Webflow) | $50-500/mo | 2-8 weeks | Validating demand |
| Freelance developer | $5-20K | 4-12 weeks | Simple apps |
| Dev agency | $20-100K | 8-24 weeks | Complex products |
| Technical co-founder | Equity | Ongoing | Long-term build |

**Rule:** Spend the minimum to learn the maximum. Don't build a $50K product to test a $500 hypothesis.

## What "Done" Looks Like

Your MVP is ready when:
- A user can complete the core action without your help
- You can explain what success looks like (specific metric)
- You have 10 people ready to try it day one

Your MVP is NOT ready when:
- You're still adding features "to be safe"
- Nobody outside your team has seen it
- Success criteria is vague ("people like it")
