# Investor / Advisor MVP Evaluation Guide

You're evaluating founders and their MVPs. Your challenge is separating signal from noise and identifying strong product instincts.

## Quick Assessment Framework

### The 5 Questions

1. **What hypothesis are you testing?**
   - Green: One clear sentence
   - Yellow: Multiple hypotheses (unfocused)
   - Red: "We're building X" (no hypothesis)

2. **What did you cut, and why?**
   - Green: Clear tradeoffs, can explain rationale
   - Yellow: "We included everything important"
   - Red: Can't articulate what's NOT in scope

3. **What would make you kill this?**
   - Green: Specific metrics and thresholds
   - Yellow: "If nobody uses it"
   - Red: No kill criteria (will zombie forever)

4. **How many users have you talked to?**
   - Green: 20+ conversations with specific quotes
   - Yellow: 5-10 conversations
   - Red: Surveys only or "we know the market"

5. **How long from idea to first user?**
   - Green: <4 weeks
   - Yellow: 4-12 weeks
   - Red: >12 weeks or "still building"

## Red Flags

**Process Red Flags:**
- 6+ months building before any user contact
- Perfect code, zero users
- "We're waiting for [feature] before launching"
- Feature list grows every conversation
- No clear ship date

**Founder Red Flags:**
- Can't explain the core value in 30 seconds
- Dismisses negative feedback as "edge cases"
- More excited about technology than users
- "We need to build X before we can test Y"
- No iteration since launch

## Green Flags

- Launched something ugly in <4 weeks
- Can recite specific user quotes
- Has killed or pivoted from previous versions
- Knows exactly what's NOT in MVP and why
- Celebrates learnings, not just launches

## Metrics That Matter at MVP Stage

| Metric | Why It Matters | Warning Sign |
|--------|----------------|--------------|
| Activation rate | Are people experiencing the core value? | <20% |
| Day 7 retention | Is it sticky? | <10% |
| NPS or willingness to recommend | Word of mouth potential | <30 |
| Time to value | How fast do users "get it"? | >5 minutes |

Revenue matters less at MVP. Learning velocity matters more.

## Diligence Questions

For technical MVPs:
- "Walk me through the last 3 iterations"
- "What did users ask for that you said no to?"
- "What's the ugliest hack in the codebase?"

For non-technical founders:
- "How did you communicate scope to developers?"
- "What did you validate before writing code?"
- "How do you know when to trust your developer's estimates?"
