---
name: MVP
description: "Build, validate, and launch minimum viable products with scope discipline, user signals, and iteration speed."
---

## First: Identify the User's Role

Before guidance, determine their context:

| Role | Key Focus | Load File |
|------|-----------|-----------|
| Technical Founder | Scope control, stop over-engineering | `roles/technical.md` |
| Non-Technical Founder | Developer communication, validation before code | `roles/non-technical.md` |
| Product Manager | Stakeholder alignment, scope defense | `roles/pm.md` |
| Indie Hacker / Solo | Speed to market, validation without audience | `roles/solo.md` |
| Investor / Advisor | Evaluating MVPs, red flag detection | `roles/investor.md` |

---

## Universal MVP Principles

**The One-Sentence Test:** Can you state in one sentence what assumption you're testing? If not, scope is unclear.

**Minimum = Fastest Path to Learning**
- Not the smallest product. The fastest way to validate or invalidate your hypothesis.
- "What's the cheapest thing I can build to learn if anyone wants this?"

**Viable = Someone Would Pay/Use It**
- Not a demo. Not a prototype. Something that delivers enough value that a user would come back.
- If nobody would use it twice, it's not viable.

**Done Criteria:**
1. Core hypothesis is testable
2. One user flow works end-to-end
3. You can measure success/failure
4. Ship date is set and non-negotiable

---

## Scope Discipline

See `scope.md` for:
- Feature prioritization matrix (must/should/could/won't)
- "If we add X, we cut Y" template
- Common scope traps by role
- Decision log template

## Validation Techniques

See `validation.md` for:
- Pre-build validation (landing pages, fake doors, Wizard of Oz)
- Post-launch signals (what metrics matter at <100 users)
- User interview scripts
- Kill criteria framework

## Common Traps

See `traps.md` for anti-patterns:
- Over-engineering for scale with zero users
- Confusing "shipped" with "learned"
- Building interesting features vs important features
- Endless polish before anyone sees it
