---
name: mux-video
description: Mux Video infrastructure skill for designing, ingesting, transcoding/packaging, playback ID policy, live streaming, clipping, and observability with Mux Data. Use when architecting or operating Mux-based video pipelines, live workflows, playback security, or diagnosing playback issues.
---

# Mux Video (Optimal)

Skill Domain: Video Infrastructure & Delivery  
Primary Platform: Mux  
Target Level: Senior / Staff / Platform Architect  
Philosophy: Video is infrastructure. Reliability beats novelty. Analytics validate reality.

---

## 0. Prime Directive

Mux Video exists to deliver video correctly, everywhere, under real-world conditions — not to feel fast in development.

All decisions optimize for:
- playback reliability
- predictable latency
- measurable experience
- operational sanity

---

## 1. Canonical Mental Model

### What Mux Video Is
- Managed video pipeline: ingest → transcode → package → distribute → secure
- Abstracts FFmpeg complexity, CDN orchestration, ABR logic, and global delivery variance

### What Mux Video Is Not
- A CMS
- A player
- A social platform
- A monetization engine

---

## 2. Asset Model (Source of Truth)

### Assets
- Canonical representation of media
- Immutable once created
- Represent media, not intent
- Spawn many playback surfaces

### Design Rule
- One asset → many experiences

### Asset Lifecycle
- Ingest (upload or live record)
- Transcode
- Package (HLS / DASH)
- Expose via Playback IDs
- Observe via Mux Data

---

## 3. Control Planes (Separation of Concerns)

Mux controls:
- ingest stability
- transcoding
- packaging
- global delivery

You control:
- identity
- entitlements
- playback authorization
- business rules
- monetization logic

Failure to respect control planes causes:
- security leaks
- brittle playback
- un-debuggable outages

---

## 4. Ingest Strategy (Critical)

### On-Demand Ingest
- File upload (API or direct upload)
- Deterministic quality
- Preferred for premium content

### Live Ingest
- RTMP only (by design)
- Encoder quality determines everything downstream

### Live Rule
- If the encoder is unstable, the stream is already lost

### Encoder Best Practices (Non-Negotiable)
- Constant frame rate
- GOP ≤ 2s (especially if clipping)
- Stable bitrate ladder
- Clean audio track

---

## 5. Encoding & Renditions

Mux automatically:
- Generates adaptive bitrate ladders
- Selects codecs
- Tunes for device compatibility

### Encoding Truth
- Mux can’t fix a bad source — only distribute it efficiently

---

## 6. Playback IDs (Exposure Layer)

### Playback IDs Are Access Keys
- Define who can watch, for how long, and under what policy
- Do not modify the asset

### Playback Policies
- `public` → open access
- `signed` → controlled access

### Security Rule
- Secure the Playback ID, not the asset

---

## 7. Playback Policy Decision Guide

Use `public` when:
- content is free or marketing
- no revenue or rights risk exists
- embedding is unrestricted

Use `signed` when:
- content is premium
- playback must expire
- access is user, geo, or entitlement based
- clips have monetization value

---

## 8. Playback URLs & Delivery

Mux delivers:
- HLS (.m3u8)
- DASH (.mpd)
- Thumbnails
- Storyboards

Mux handles:
- CDN selection
- regional routing
- device compatibility

### Latency Philosophy
- On-demand → stability > speed
- Live → latency is a tradeoff curve
- There is no free low-latency lunch

---

## 9. Live Streaming (Operational Reality)

Live is a distributed failure generator. Expect:
- packet loss
- dropped frames
- network variance
- device heterogeneity

Mux mitigates — it does not eliminate.

### Live Best Practices
- Always auto-record
- Always monitor ingest
- Always test encoder profiles
- Never assume “it’ll be fine”

---

## 10. Live Latency Reality

- Ultra-low latency increases failure sensitivity
- Lower latency reduces buffer safety
- Buffering is a reliability feature, not a bug

Choose latency based on:
- audience tolerance
- interaction requirements
- failure cost

---

## 11. Asset Clipping (First-Class Skill)

### Clipping Model
Clips are derivative assets defined by:
- source asset
- start_time
- end_time

### Rules
- Source asset is immutable
- Clips are disposable
- Clips have independent analytics

### Why Clipping Matters
- highlights
- previews
- modular content
- monetization tiers
- social repurposing

### Precision Constraint
Clip accuracy depends on keyframe placement and encoder GOP size. Design accordingly.

---

## 12. Player Responsibility Boundary

Mux delivers streams.  
The player renders video, reports telemetry, and controls UX.

### Rule
- A bad player can sabotage a perfect pipeline

---

## 13. Observability Hook (Mux Data Dependency)

Mux Video without Mux Data is a blind system.

### Requirement
Every production playback must:
- report sessions
- surface QoE metrics

No exceptions.

---

## 14. Observability Escalation Ladder

1. Playback failure rate increase
2. Startup time regression
3. Rebuffer ratio spike
4. Device or browser correlation
5. Region-specific anomalies
6. Ingest window correlation

If you start debugging elsewhere, you’re guessing.

---

## 15. Operational Playbooks

### Playback Issues
- Validate playback ID
- Check startup time
- Inspect error rates
- Segment by device and browser
- Correlate with ingest timing

### Live Stream Failure
- Inspect encoder logs
- Validate RTMP stability
- Compare bitrate ladder output
- Check regional impact
- Fallback to recording

---

## 16. Anti-Patterns

- Treating assets like content objects
- Editing video “in Mux”
- Ignoring encoder configuration
- Using public playback IDs for premium content
- Shipping unobserved video

---

## 17. Cost Reality

Mux optimizes delivery cost.

You control:
- asset volume
- clip proliferation
- playback duration
- entitlement abuse

Unbounded playback equals silent spend.

---

## 18. Scaling Model

Mux scales:
- ingest
- transcoding
- delivery

You scale:
- auth
- identity
- entitlements
- metadata
- business logic

Mux provides delivery truth.  
OpenClaw provides ownership, rights, access, and monetization intelligence.

---

## 19. Operational Fluency Signals

You’ve mastered Mux Video when you can:
- diagnose playback failures from metrics alone
- design live streams for failure tolerance
- atomize long-form content into clips at scale
- secure playback without user friction
- treat video as infrastructure, not media

---

## 20. Extension Points (Next Skills)

- Mux Data (deep analytics)
- Live highlight automation
- Signed playback architectures
- Clip-to-revenue attribution
- AI-driven QoE optimization
