# Udio

**Best for:** High-fidelity songs, complex arrangements, professional quality

**Web:** https://udio.com/

## Overview

Udio generates complete songs with vocals and instrumentation. Known for higher audio fidelity and more complex musical arrangements compared to alternatives.

## Features

- Full songs with AI vocals
- High-quality audio (up to 48kHz)
- Style transfer from reference tracks
- Extend and remix existing generations

## Web Interface

1. Go to https://udio.com/
2. Describe your song in detail
3. Optionally add lyrics
4. Generate multiple variations
5. Download best result

## API Access

**Note:** No official public API yet. Web-based generation only.

**Unofficial wrappers may exist** — check third-party services like PiAPI or AIML API.

## Prompt Structure

```
[Genre], [mood], [era/style], [instruments], [vocal style]
```

**Examples:**
- "70s disco funk with groovy bassline, brass section, female diva vocals"
- "Modern trap beat with heavy 808s, hi-hats, and autotuned vocals"
- "Cinematic orchestral piece with sweeping strings and epic brass"

## Custom Lyrics

Same format as other generators:

```
[Intro]
Instrumental intro

[Verse 1]
Your lyrics here

[Chorus]
Hook goes here
```

## Quality Settings

- **Standard** — Faster, good quality
- **High Quality** — Slower, better fidelity

## Extend Feature

Continue a generated song:
1. Select existing generation
2. Choose extend direction (forward/backward)
3. Add prompt for new section
4. Generate continuation

## Pricing

- **Free:** Limited generations per month
- **Standard ($10/mo):** 1,200 credits
- **Pro ($30/mo):** 4,800 credits

## Comparison with Suno

| Feature | Udio | Suno |
|---------|------|------|
| Audio quality | Higher | Good |
| Vocal clarity | Better | Good |
| Generation speed | Slower | Faster |
| API access | No | Unofficial |
| Free tier | Limited | Generous |

## Tips

- More detailed prompts = better results
- Reference specific artists or eras
- Use extend to build longer songs
- Generate multiple versions and pick best
- High Quality mode for final exports
