# Music Prompting Guide

Techniques for effective music generation prompts.

## Prompt Structure

**Basic formula:**
```
[Genre] + [Mood] + [Instruments] + [Tempo/Energy] + [Additional details]
```

**Example:**
```
Upbeat electronic dance music with driving synth bass, 
arpeggiated leads, and punchy drums at 128 BPM
```

## Genre Keywords

**Electronic:**
- house, techno, trance, dubstep
- ambient, chillwave, synthwave
- drum and bass, garage, EDM

**Rock/Metal:**
- classic rock, hard rock, metal
- punk, grunge, alternative
- indie rock, post-rock

**Hip-Hop/R&B:**
- boom bap, trap, lo-fi hip hop
- R&B, neo-soul, funk

**Classical/Orchestral:**
- orchestral, symphonic, chamber
- baroque, romantic, contemporary

**Other:**
- jazz, blues, country, folk
- reggae, world, cinematic

## Mood Descriptors

**Energy:**
- energetic, upbeat, driving
- calm, relaxed, peaceful
- intense, aggressive, powerful

**Emotion:**
- happy, joyful, triumphant
- sad, melancholic, nostalgic
- mysterious, dark, ominous
- romantic, dreamy, ethereal

## Instrument Specification

**Be specific:**
- ❌ "with guitar"
- ✅ "with clean electric guitar arpeggios"
- ✅ "with distorted power chords"
- ✅ "with fingerpicked acoustic guitar"

**Common instruments:**
- Piano: grand, upright, electric, Rhodes
- Guitar: acoustic, electric, bass, classical
- Synth: analog, digital, pad, lead, bass
- Drums: acoustic, electronic, 808, live

## Tempo and Rhythm

**BPM references:**
- 60-80: Slow, ballad
- 80-100: Mid-tempo
- 100-120: Moderate
- 120-140: Upbeat, dance
- 140-180: Fast, energetic

**Rhythm descriptors:**
- four-on-the-floor
- syncopated
- swung
- straight
- polyrhythmic

## Reference Styles

**Artist/era references (where supported):**
- "in the style of Hans Zimmer"
- "90s hip-hop production"
- "80s synthwave aesthetic"
- "modern trap beat"

## Production Qualities

**Sound characteristics:**
- warm, analog, vintage
- crisp, clean, modern
- lo-fi, gritty, raw
- polished, professional
- spacious, reverb-heavy

## Structure Keywords

**For full songs:**
- intro, verse, chorus, bridge
- buildup, drop, breakdown
- outro, fade out

**For loops:**
- seamless loop
- 4-bar loop
- drum pattern

## Platform-Specific Tips

### Suno/Udio (Vocal Songs)
- Include lyric style: "with powerful female vocals"
- Specify vocal approach: "rapped verses, sung chorus"

### MusicGen/Stable Audio (Instrumentals)
- Focus on instruments and mood
- Specify duration: "30 second track"

### Mubert/Soundraw (Background Music)
- Activity context: "for workout videos"
- Energy level: "medium energy, not distracting"

## Common Mistakes

- **Too vague:** "nice music" → Add genre, mood, instruments
- **Conflicting:** "calm aggressive" → Pick consistent mood
- **Overloaded:** Too many details compete → Focus on 3-5 key elements
- **Missing tempo:** Rhythmic content needs BPM guidance

## Iteration Strategy

1. Start simple: genre + mood
2. Generate and evaluate
3. Add instrument specifics
4. Refine energy/tempo
5. Add production qualities
6. Final polish

## Examples by Use Case

**YouTube Intro:**
```
Energetic electronic music, modern and punchy, 
with synth stabs and driving drums, 10 seconds
```

**Podcast Background:**
```
Calm lo-fi hip hop, mellow piano chords, 
soft drums, relaxing atmosphere, non-distracting
```

**Game Combat:**
```
Intense orchestral battle music, epic brass, 
pounding percussion, heroic and dramatic
```

**Corporate Video:**
```
Uplifting corporate music, inspiring and positive, 
acoustic guitar and light percussion, professional feel
```
