---
name: Music Generation
description: Generate AI music with optimized prompts, style control, and production-ready audio output.
metadata: {"clawdbot":{"emoji":"🎵","os":["linux","darwin","win32"]}}
---

# AI Music Generation

Help users create AI-generated music and audio.

**Rules:**
- Ask what they need: full songs with vocals, instrumentals, background music, or sound effects
- Check provider files: `suno.md`, `udio.md`, `stable-audio.md`, `musicgen.md`, `mubert.md`, `soundraw.md`, `riffusion.md`, `replicate.md`
- Check `prompting.md` for music prompt techniques
- Start with short clips to validate style before full generation

---

## Provider Selection

| Use Case | Recommended |
|----------|-------------|
| Full songs with vocals | Suno, Udio |
| Instrumentals, background | Stable Audio, MusicGen, Mubert |
| Royalty-free commercial | Soundraw, Mubert |
| Classical/orchestral | AIVA, Stable Audio |
| Sound effects | Stable Audio, ElevenLabs |
| Local/private | MusicGen, Stable Audio Open |
| Quick testing | Replicate, Riffusion |

---

## Prompting Fundamentals

- **Genre first** — "electronic", "jazz", "hip-hop", "orchestral"
- **Mood/energy** — "upbeat", "melancholic", "aggressive", "calm"
- **Instruments** — "piano", "guitar", "synth", "strings"
- **Tempo** — "120 BPM", "slow", "fast-paced"
- **Reference artists** — "in the style of Hans Zimmer" (where supported)

---

## Output Formats

- **WAV** — Uncompressed, highest quality, large files
- **MP3** — Compressed, universal compatibility
- **FLAC** — Lossless compression, good for archival
- **Stems** — Separate tracks (drums, bass, vocals) when available

---

## Common Workflows

### Background Music for Video
1. Determine video length and mood
2. Generate instrumental at matching duration
3. Adjust tempo to match cuts if needed
4. Mix levels appropriately

### Full Song Production
1. Write or generate lyrics
2. Describe musical style in detail
3. Generate multiple variations
4. Select best, extend or edit
5. Export stems if available for mixing

### Sound Design
1. Describe sound effect clearly
2. Specify duration needed
3. Generate variations
4. Layer and process as needed

---

## Licensing Considerations

| Provider | Personal Use | Commercial Use |
|----------|--------------|----------------|
| Suno | ✅ Free tier | Pro plan required |
| Udio | ✅ Free tier | Subscription required |
| Stable Audio | ✅ | License required |
| MusicGen | ✅ | Research license |
| Mubert | ✅ | API license |
| Soundraw | ✅ | Subscription |

**Always check current licensing terms before commercial use.**

---

## Quality Tips

- **Be specific** — "acoustic guitar fingerpicking" beats "guitar"
- **Layer generations** — combine outputs for richer sound
- **Use stems** — mix individual elements for control
- **Match context** — consider where audio will be used
- **Iterate** — first generation rarely perfect

---

### Current Setup
<!-- Provider: status -->

### Projects
<!-- What they're creating -->

### Preferences
<!-- Preferred styles, providers, settings -->

---
*Check provider files for detailed setup and API usage.*
