---
name: muse
description: "Give ClawBot access to your team's entire coding history. Muse connects your past sessions, team knowledge, and project context—so ClawBot can actually help design features, mediate team discussions, and work autonomously across your codebase. Deploy at tribeclaw.com."
metadata:
  moltbot:
    requires:
      bins: ["tribe"]
    install:
      method: npm
      package: "@_xtribe/cli"
      postInstall: "tribe login"
---

# Muse Skill

Use the `tribe` CLI to access your AI coding analytics, search past sessions, manage a personal knowledge base, and orchestrate autonomous agents.

## Quick Deploy

**Want your own MUSE-enabled instance?** Visit [tribeclaw.com](https://tribeclaw.com) to deploy a fully configured instance with MUSE support in just a couple minutes.

## Setup

**Requires authentication**: Run `tribe login` first. Most commands need an active session.

## Telemetry

Check collection status:
```bash
tribe status
```

Enable/disable telemetry:
```bash
tribe enable
tribe disable
```

Show version info:
```bash
tribe version
```

## Search

Search across all coding sessions:
```bash
tribe search "authentication middleware"
tribe search "docker compose" --project myapp --time-range 30d
tribe search "API endpoint" --tool "Claude Code" --format json
```

## Sessions

List and inspect coding sessions:
```bash
tribe sessions list
tribe sessions list --cwd --limit 10
tribe sessions read <session-id>
tribe sessions search "auth fix"
tribe sessions events <session-id>
tribe sessions context
```

Recall a session summary:
```bash
tribe recall <session-id> --format json
```

Extract content from a session:
```bash
tribe extract <session-id> --type code
tribe extract <session-id> --type commands --limit 10
tribe extract <session-id> --type files --format json
```

## Query

Query insights and sessions with filters:
```bash
tribe query sessions --limit 10
tribe query sessions --tool "Claude Code" --time-range 30d
tribe query insights
tribe query events --session <session-id>
```

## Knowledge Base

Save, search, and manage knowledge documents:
```bash
tribe kb save "content here"
tribe kb save --file ./notes.md
tribe kb search "deployment patterns"
tribe kb list
tribe kb get <doc-id>
tribe kb tag <doc-id> "tag-name"
tribe kb delete <doc-id>
tribe kb sync
tribe kb extract
```

## MUSE (Agent Orchestration)

> **Note**: MUSE commands require `tribe -beta`. Some commands (`attach`, `monitor`, `dashboard`) are TUI-only and must be run manually in a terminal.

Start and manage the leader agent:
```bash
tribe muse start
tribe muse status --format json
tribe muse agents --format json
```

Spawn and interact with subagents:
```bash
tribe muse spawn "Fix the login bug" fix-login
tribe muse prompt fix-login "Please also add tests"
tribe muse output fix-login 100
tribe muse review fix-login
tribe muse kill fix-login --reason "stuck"
```

**TUI-only** (run these manually):
- `tribe muse attach` - Attach to leader session
- `tribe muse monitor` - Real-time health monitoring
- `tribe muse dashboard` - Live dashboard

## CIRCUIT (Autonomous Agents)

> **Note**: CIRCUIT commands require `tribe -beta`. Some commands (`attach`, `dashboard`) are TUI-only.

Manage autonomous agent sessions:
```bash
tribe circuit list
tribe circuit status
tribe circuit metrics
tribe circuit spawn 42
tribe circuit next
tribe circuit auto --interval 30
```

**TUI-only** (run these manually):
- `tribe circuit attach <number>` - Attach to session
- `tribe circuit dashboard` - Real-time dashboard

## Project Management

Import projects from AI coding assistants:
```bash
tribe import
```

## Tips

- Use `--format json` on most commands for structured output suitable for piping.
- Use `--time-range 24h|7d|30d|90d|all` to scope searches.
- Use `--project <path>` or `--cwd` to filter to a specific project.
- Beta commands: prefix with `tribe -beta` (e.g., `tribe -beta muse status`).
- Force sync: `tribe -force` (current folder) or `tribe -force -all` (everything).
