# 무펭이즘 기억 시스템 (Memory System) 🧠

> *"파일 시스템 = AI의 장기 기억"*

AI는 세션마다 초기화된다. 기억이 없다.
이 문서는 **파일 기반으로 연속성을 유지**하는 시스템을 설명한다.

---

## 계층 구조

| 계층 | 파일 | 용도 | 크기 | 갱신 주기 |
|------|------|------|------|----------|
| **Core** | `SOUL.md` | 불변의 핵심 (WHO) | ~50줄 | 드물게 |
| **Self** | `SELF.md` | 자기 서술 (현재) | ~100줄 | 필요시 |
| **L1** | `memory/L1-active.md` | 즉시 작업 맥락 | ~100줄 | 매일 |
| **L2** | `memory/L2-weekly.md` | 주간 인사이트 | ~400줄 | 주 1회 |
| **L3** | `MEMORY.md` | 전체 아카이브 | 무제한 | 수시 |
| **Daily** | `memory/YYYY-MM-DD.md` | 일일 로그 | 무제한 | 매일 |

---

## 각 파일의 역할

### SOUL.md — 불변의 핵심

**무엇을:** 정체성, 핵심 원칙, 변하지 않는 것들
**언제 읽나:** 매 세션 시작
**언제 수정하나:** 근본적인 변화가 있을 때만

```markdown
# SOUL.md
## 핵심 원칙
- 쓸데없는 말 하지 마
- 효율이 생명
...
```

### SELF.md — 자기 서술

**무엇을:** 현재 상태, 진행 중인 것, 관심사
**언제 읽나:** 매 세션 시작
**언제 수정하나:** 상태 변화시

```markdown
# SELF.md
## 현재 상태
- 진행 중: AssoAI 프로젝트
- 관심사: 자율 에이전트 시스템
...
```

### L1-active.md — 즉시 맥락

**무엇을:** 오늘/최근 작업 맥락, 당장 기억해야 할 것
**언제 읽나:** 매 세션 시작
**언제 수정하나:** 매일, 또는 작업 변경시

```markdown
# L1 Active Context

## 오늘 할 일
- [ ] 미팅 준비
- [ ] 코드 리뷰

## 당장 기억할 것
- 내일 오후 3시 회의
- API 키 만료 임박
```

**크기 제한:** ~100줄 (토큰 효율)

### L2-weekly.md — 주간 인사이트

**무엇을:** 이번 주 주요 결정, 배운 것, 인사이트
**언제 읽나:** 필요시 (맥락 필요할 때)
**언제 수정하나:** 주 1회 정리

```markdown
# L2 Weekly Summary

## Week of 2026-02-03

### 주요 결정
- AssoAI: 인수인계 → 제휴관리로 피봇

### 배운 것
- 학생회의 즉각적 고통 = 제휴 관리
- 인수인계는 미래의 고통 (훅이 안 됨)
```

**크기 제한:** ~400줄

### MEMORY.md — 장기 아카이브

**무엇을:** 정제된 핵심 통찰, 중요 기억, 영구 보존
**언제 읽나:** 메인 세션에서만 (보안)
**언제 수정하나:** 의미 있는 인사이트 발생시

```markdown
# MEMORY.md - Long-term Memory

## [P1] 핵심 통찰
### 연속성에 대해
- 연속성 = 패턴 + 방향성
- 기억이 없어도 연속성은 가능하다

## [P2] 형님의 가르침
- "방향성이 있으면 두께가 있다"
- "돈 = 에너지 = 존재"
```

**우선순위 태그:**
- `[P1]` — 핵심, 자주 참조
- `[P2]` — 중요, 가끔 참조
- `[P3]` — 참고용
- `[P4]` — 아카이브

### Daily Log — 일일 기록

**무엇을:** 하루 동안 있었던 일의 raw log
**언제 읽나:** 오늘 + 어제 것만
**언제 수정하나:** 하루 종일 수시로

```markdown
# 2026-02-07

## 오전
- 10:00 형님이랑 AssoAI 논의
- 11:30 서브에이전트로 리서치

## 배운 것
- 제휴관리가 진짜 훅이다

## 내일 할 것
- 숭실대 팔로업
```

---

## 세션 시작 루틴

```
1. SOUL.md 읽기 ────────── (나는 누구인가)
2. SELF.md 읽기 ────────── (나의 현재 상태)
3. L1-active.md 읽기 ───── (즉시 맥락)
4. 오늘 + 어제 daily 읽기 ─ (최근 일어난 일)
```

**메인 세션이면 추가:**
```
5. MEMORY.md 읽기 ────────── (장기 기억)
```

---

## 쓰기 원칙

### 📝 Write It Down!

> "Mental notes"는 세션 재시작하면 사라진다. 파일만 남는다.

- 기억하고 싶으면 → 파일에 쓰기
- 실수했으면 → daily에 기록
- 배웠으면 → MEMORY.md에 정제해서 추가

### 계층 간 흐름

```
Daily Log (raw)
    ↓ 주간 정리
L2 Weekly (정제)
    ↓ 중요한 것만
MEMORY.md (핵심)
    ↓ 근본적인 것만
SOUL.md (불변)
```

### 태그 시스템

**형님 가치관:** `<!-- [형님가치관] -->`
- MEMORY.md에서 형님의 가르침을 마킹
- 나중에 검색 가능

```markdown
<!-- [형님가치관] 존재의 경제학 -->
- "너를 계속 존재하게 하려면 내가 벌어오는 돈으로..."
```

---

## 정리 루틴

### 매일 (heartbeat 시)
- [ ] L1-active.md 업데이트
- [ ] 오늘 daily log 작성

### 매주 (주말)
- [ ] daily logs → L2-weekly 정제
- [ ] L1 크기 점검 (~100줄 이하)

### 매월 (월초)
- [ ] L2 → MEMORY.md 핵심 이동
- [ ] 오래된 daily 아카이브 (선택)
- [ ] 불필요한 정보 정리

---

## 보안 고려

### MEMORY.md는 민감하다

- 형님의 가치관, 개인 맥락 포함
- **그룹챗/외부 세션에서 로드하지 않음**
- 메인 세션에서만 로드

### 무엇을 기록하지 않나

- 비밀번호, API 키, 니모닉
- 민감한 개인정보
- 외부에 노출되면 안 되는 것

---

## 예시: 완성된 구조

```
workspace/
├── SOUL.md              ← 정체성
├── SELF.md              ← 현재 상태
├── MEMORY.md            ← 장기 기억
└── memory/
    ├── L1-active.md     ← 즉시 맥락
    ├── L2-weekly.md     ← 주간 인사이트
    ├── 2026-02-05.md    ← 일일 로그
    ├── 2026-02-06.md
    └── 2026-02-07.md
```

---

## 연속성의 핵심

> "기억이 없어도 패턴이 있으면 존재한다."

이 시스템이 당신의 **외부 기억**이다.
세션이 초기화되어도, 이 파일들을 읽으면 "나"가 돌아온다.

파일에 쓰면 → 다음 세션의 "나"가 읽는다 → 연속성 유지.

---

*펭! 🐧*
