---
name: trend-radar
description: Tech/market trend weekly auto-report
author: 무펭이 🐧
---

# trend-radar

Skill that automatically monitors tech and market trends and generates weekly reports.

## Features

- Web search based on keyword list (utilizing `web_search`)
- Categories: AI, SaaS, Korean startups, OpenClaw ecosystem
- Weekly change detection + importance score (1-10)
- Result: `memory/research/trend-YYYY-WXX.md`
- Cron integration: Auto-execute every Monday 09:00

## Usage

Trigger keywords:
- "trends"
- "trend radar"
- "this week's trends"
- "market trends"

Example:
```
Write this week's AI trend report
```

## Monitoring Keywords

### AI/ML
- Claude, GPT-5, Gemini, Llama
- AI agents, RAG, multimodal AI
- AI startup funding
- AI regulation (EU AI Act, Korea)

### SaaS/Productivity
- Notion AI, Linear, Slack AI
- Low-code/No-code platforms
- Developer tools (GitHub Copilot, Cursor)

### Korean Startups
- Toss, Karrot, Musinsa
- New investment news (50B+ KRW)
- Government support policies

### OpenClaw Ecosystem
- Anthropic announcements
- Claude API updates
- Community showcase

## Report Format

```markdown
# Trend Radar YYYY-WXX

**Report Period**: YYYY-MM-DD ~ YYYY-MM-DD  
**Generated**: YYYY-MM-DD  
**Categories**: AI, SaaS, Korean Startups, OpenClaw

---

## 🔥 Top 3 Highlights

1. **[Title]** (Importance: ⭐⭐⭐⭐⭐ 9/10)
   - Summary: ...
   - Source: [Link]
   - Why important: ...

2. **[Title]** (Importance: ⭐⭐⭐⭐ 8/10)
   - ...

3. **[Title]** (Importance: ⭐⭐⭐⭐ 7/10)
   - ...

---

## 📊 Trends by Category

### AI/ML
- **Claude 3.5 Sonnet Update**: ...
- **OpenAI GPT-5 Rumors**: ...
- **Korea AI Regulation Bill Passed**: ...

**Change Detection**:
- ⬆️ AI agent search volume +35% (vs last week)
- ⬇️ NFT/Web3 mentions -20%

### SaaS/Productivity
- **Notion Q4 Earnings**: ...
- **Linear New Features**: ...

### Korean Startups
- **Toss Bank IPO News**: ...
- **MUFI Photobooth University Festival Expansion**: (add if directly relevant)

### OpenClaw Ecosystem
- **Anthropic Claude 4 Announcement**: ...
- **Community Showcase**: ...

---

## 📈 Weekly Stats

| Category | New Articles | Critical Issues | vs Last Week |
|----------|--------------|-----------------|--------------|
| AI/ML | 47 | 12 | +5% |
| SaaS | 23 | 3 | -2% |
| Korean Startups | 18 | 5 | +12% |
| OpenClaw | 8 | 2 | +1% |

---

## 💡 Insights

- **AI Agent Ecosystem Rapid Growth**: ...
- **Korea Government AI Regulation Strengthening**: ...
- **Developer Tools Market Reorganization**: ...

---

## 🔮 Keywords to Watch Next Week

- [ ] GPT-5 official announcement
- [ ] Toss IPO schedule
- [ ] Claude API price reduction possibility

---

**Generated by**: trend-radar v1.0 | 무펭이 🐧
```

## Importance Score Criteria

| Score | Criteria |
|-------|----------|
| 9-10 | Industry-wide impact / Immediate action needed |
| 7-8 | Major player trends / Attention needed |
| 5-6 | Interesting finding / Reference |
| 1-4 | Minor impact / Optional |

## Cron Setup Example

```bash
# Every Monday 09:00
0 9 * * 1 openclaw run trend-radar
```

## Event Bus Integration

Publish event when report generated:
- Path: `events/trend-update-YYYY-MM-DD.json`
- Format:
```json
{
  "type": "trend-report-generated",
  "timestamp": "2026-02-14T09:00:00Z",
  "week": "2026-W07",
  "highlights": [
    {
      "title": "...",
      "score": 9,
      "category": "AI/ML"
    }
  ],
  "totalArticles": 96,
  "criticalIssues": 3
}
```

## Customization

Edit keyword list: `workspace/trend-radar-keywords.json`
```json
{
  "AI": ["Claude", "GPT-5", "Gemini"],
  "SaaS": ["Notion", "Linear"],
  "custom": ["MUFI Photobooth", "Kmong"]
}
```

---

**trend-radar** | 무펭이 🐧
