# Mumbai Visitor Tips & Day Trips

## Essential Tips

### Arrival
- **Airport**: Chhatrapati Shivaji Maharaj International (BOM)
- **Terminal 2**: International flights, beautiful terminal (Jaya He installation)
- **Terminal 1**: Domestic, being upgraded
- **To city center**: Prepaid taxi (₹500-800 to South Mumbai), Uber/Ola (₹400-600)
- **Avoid**: Random taxi touts. Use official prepaid booth or app.
- **Time to city**: 1-3 hours depending on traffic (yes, that much variance)

### Money
- **Currency**: Indian Rupee (INR/₹)
- **ATMs**: Everywhere, HDFC and ICICI have best rates
- **Cards**: Widely accepted in malls, restaurants, hotels
- **Cash needed**: Street food, markets, autos, small shops
- **Tip**: Carry small denominations (₹10, ₹20, ₹50)
- **Foreign exchange**: Thomas Cook, BookMyForex, airport

### SIM Card
- **Best options**: Jio, Airtel (both good coverage)
- **Where**: Airport arrival hall, any phone shop
- **Need**: Passport photo, passport copy
- **Cost**: ₹200-500 for tourist SIM with data
- **Time**: Can take 1-24 hours to activate

### Language
- **Hindi**: Most widely spoken
- **Marathi**: Local language, appreciated if you learn basics
- **English**: Understood in business areas, hotels, educated population
- **Google Translate**: Useful for signs, menus

### Safety
- **Petty theft**: Watch bags in crowded areas
- **Scams**: Inflated prices for tourists, fake guides
- **Traffic**: Look both ways constantly, cars won't stop
- **Night safety**: Generally safe in main areas, use cabs
- **Women travelers**: Dress modestly, especially in local areas

---

## Getting Around

### Uber/Ola
- **Best for**: Comfort, AC, door-to-door
- **Cost**: ₹15-25/km approximately
- **Tip**: Pool/Share options save money
- **Issue**: Traffic makes rides long
- **Always**: Confirm car number, share trip

### Local Trains
- **Best for**: Speed (when not rush hour)
- **Lines**: Western, Central, Harbour
- **Cost**: ₹5-20 per ride
- **Classes**: First class (less crowded, ₹10-40), Second class (packed)
- **Avoid**: 8-10am and 5-8pm (dangerously crowded)
- **App**: m-Indicator for schedules

### Auto Rickshaws
- **Where**: Suburbs only (not South Mumbai)
- **Cost**: Meter + ₹1.5/km, minimum ₹21
- **Reality**: Many refuse to go by meter. Negotiate or use app.
- **Alternative**: Uber Auto, Ola Auto (fixed price)

### Taxis
- **Black & Yellow**: Iconic Mumbai taxis
- **Cost**: Meter-based, ₹22 first km, ₹15/km after
- **Issue**: Older cars, no AC
- **AC taxis**: Blue/silver, higher tariff
- **Tip**: Insist on meter or agree price beforehand

### Metro
- **Lines**: Expanding network
- **Currently**: Line 1 (Ghatkopar-Versova) most useful for tourists
- **Cost**: ₹10-40
- **Best for**: Avoiding traffic on specific routes
- **Note**: Not as extensive as Delhi Metro yet

---

## Best Times to Visit

| Month | Weather | Crowds | Notes |
|-------|---------|--------|-------|
| October | Cooling, post-monsoon | High | Festivals (Navratri, Diwali) |
| November | Perfect, 25-32°C | Very High | Peak season begins |
| December | Best, 20-28°C | Highest | Christmas/NYE crowds |
| January | Cool, 18-28°C | High | Best weather |
| February | Warming up | High | Kala Ghoda Festival |
| March | Hot, 25-35°C | Moderate | Holi celebrations |
| April | Hot, 28-38°C | Low | Pre-monsoon heat |
| May | Very hot, humid | Lowest | Locals escape to hills |
| June | Monsoon starts | Low | Dramatic weather, flooding |
| July | Heavy rain | Low | Seriously wet |
| August | Rain continues | Low | Ganesh Chaturthi (big!) |
| September | Monsoon ending | Moderate | Humidity high |

**Best months**: November to February
**Avoid**: May to early September (unless you love monsoon)

---

## Cultural Tips

### Temple Etiquette
- Remove shoes before entering
- Dress modestly (cover shoulders/knees)
- Don't point feet at deities
- Photography often restricted inside
- Small donation appreciated

### Mosque Etiquette
- Remove shoes
- Women cover head (scarves usually available)
- Dress modestly
- Don't visit during prayer times
- Photography: Ask permission

### General Behavior
- **Namaste**: Hands together, slight bow. Universal greeting.
- **Right hand**: Use for eating, giving, receiving
- **Head wobble**: Not yes or no, more like "okay/understood"
- **Personal space**: Different norms in crowds
- **Punctuality**: Flexible in social settings, important in business

### Bargaining
- **Where**: Street markets, local shops
- **Where not**: Malls, restaurants, branded stores
- **Start at**: 40-50% of asking price
- **Walk away**: Often brings better price
- **Good spirit**: Keep it friendly, not aggressive

---

## What to Pack

### Essential
- Comfortable walking shoes (will get dirty)
- Light cotton clothing (breathable)
- Modest outfits for temples
- Sunscreen and sunglasses
- Reusable water bottle
- Hand sanitizer
- Universal power adapter (Type C/D/M plugs)

### Monsoon (June-September)
- Waterproof bag
- Umbrella (compact)
- Quick-dry clothes
- Waterproof sandals/shoes
- Plastic bags for electronics

### Summer (March-May)
- Hat or cap
- Extra water bottle
- Light, loose clothing
- Cooling towel

---

## Day Trips from Mumbai

### Lonavala & Khandala (2-2.5 hours)
- Hill stations, cooler weather
- See: Tiger Point, Bhushi Dam, Karla Caves
- Best: Monsoon (waterfalls) or winter
- Stay: Overnight possible, many resorts
- Must try: Chikki (local sweet)

### Alibaug (2 hours by ferry + road)
- Beach town, weekend getaway
- See: Kolaba Fort (accessible at low tide), beaches
- Best: November-February
- Getting there: Ferry from Gateway to Mandwa + auto

### Matheran (2.5 hours)
- No-vehicle hill station
- See: Echo Point, Charlotte Lake, sunset views
- Best: Post-monsoon, winter
- Getting there: Drive to Neral, then toy train (experience!)
- Note: Weekends very crowded

### Elephanta Island (1 hour ferry)
- UNESCO World Heritage caves
- See: 6th century rock-cut temples
- Best: October-March
- Getting there: Ferry from Gateway of India
- Note: Closes during monsoon

### Karnala (1.5 hours)
- Bird sanctuary, trekking
- See: Karnala Fort, 150+ bird species
- Best: November-February (bird migration)
- Good for: Nature lovers, photographers

### Pune (3-4 hours)
- Major city, food scene, Osho Ashram
- See: Aga Khan Palace, Shaniwar Wada
- Best: Any time
- Getting there: Train (Deccan Express) or car

### Nashik (3-4 hours)
- Wine country, temples
- See: Sula Vineyards, Panchavati temples
- Best: September-March
- Good for: Wine lovers, pilgrims

### Aurangabad (6 hours or 1 hour flight)
- Ajanta & Ellora Caves (UNESCO)
- See: Ancient Buddhist/Hindu rock-cut temples
- Best: October-March
- Recommend: 2-day trip minimum

---

## Common Scams to Avoid

### Taxi/Auto Scams
- "Meter broken" — insist on meter or leave
- "Hotel closed" — never true, they want commission
- Long routes — use Google Maps
- **Solution**: Use Uber/Ola

### Tourism Scams
- Fake guides at monuments
- "Free" tours that pressure for money
- Overpriced boat rides at Gateway
- **Solution**: Book through hotels or verified platforms

### Shopping Scams
- "Export quality" fake goods
- Bait and switch on shipped items
- Hugely inflated tourist prices
- **Solution**: Compare prices, check quality, don't ship

### General Scams
- Sob stories asking for money
- "Helpful" strangers leading you to shops
- Fake police asking for money
- **Solution**: Politely decline, walk away

---

## Useful Apps

| App | Purpose |
|-----|---------|
| Uber/Ola | Taxi booking |
| m-Indicator | Local train schedules |
| Google Maps | Navigation (better than Apple Maps here) |
| Zomato/Swiggy | Food delivery and restaurant reviews |
| BookMyShow | Movies, events tickets |
| MakeMyTrip | Hotels, flights |
| Paytm | Mobile payments (widely accepted) |
| WhatsApp | Everyone uses it |

---

## Emergency Information

- **Police**: 100
- **Ambulance**: 102
- **Fire**: 101
- **Tourist helpline**: 1800-111-363
- **US Embassy**: +91-22-2672-4000
- **UK Embassy**: +91-22-6650-2222

### Hospitals (Recommended)
- **Breach Candy Hospital** (South Mumbai)
- **Lilavati Hospital** (Bandra)
- **Kokilaben Hospital** (Andheri)
- **Bombay Hospital** (Marine Lines)
