# Mumbai Visa Guide

## Visa Types Overview

| Visa | Duration | Work Allowed | Best For |
|------|----------|--------------|----------|
| Tourist (e-Visa) | 30/90/180 days | No | Short visits |
| Business | 1-5 years | Meetings only | Business travel |
| Employment | 1-5 years | Yes (with sponsor) | Working in India |
| Conference | Event duration | No | Specific events |
| Student | Course duration | Limited | Studying |
| Research | Project duration | Research only | Academic |
| Journalist | 6 months-1 year | Yes | Media |
| OCI | Lifetime | Yes | Indian-origin persons |
| PIO | Superseded by OCI | — | — |

---

## Tourist Visa (e-Visa)

### Types
| Type | Validity | Entries | Fee |
|------|----------|---------|-----|
| 30-day | 30 days | Double entry | $25-50 |
| 1-year | 1 year | Multiple | $40-80 |
| 5-year | 5 years | Multiple | $80-150 |

### How to Apply
1. Go to indianvisaonline.gov.in
2. Fill application form
3. Upload photo and passport scan
4. Pay fee online
5. Receive ETA via email (2-4 days)
6. Print ETA, show at immigration

### Requirements
- Passport valid 6+ months
- Recent photo
- Return ticket
- Accommodation proof
- Sufficient funds

### Restrictions
- Cannot work or study
- Cannot extend easily
- Must exit and re-enter for new visa

---

## Business Visa

### For
- Business meetings
- Trade fairs
- Contract negotiations
- Technical discussions
- NOT for employment

### Duration
- 6 months to 5 years
- Multiple entry

### Requirements
- Invitation from Indian company
- Company letterhead from home country
- Business registration proof
- Financial documents

### Process
- Apply at Indian embassy/consulate
- Or BLS/VFS visa center
- Processing: 5-10 working days

---

## Employment Visa

### Requirements
- Job offer from Indian company
- Salary > $25,000/year (general guideline)
- Specialized skills
- Company registration documents
- Educational qualifications

### Process
1. Company issues offer letter
2. Apply at Indian embassy/VFS
3. Submit documents:
   - Employment contract
   - Company financials
   - Educational certificates
   - Resume
4. Processing: 2-4 weeks
5. Register with FRRO within 14 days of arrival

### Duration
- Initial: 1-2 years
- Renewable up to 5 years
- Beyond 5 years: More scrutiny

### FRRO Registration
**Mandatory** within 14 days of arrival:
- Online registration at indianfrro.gov.in
- Appointment at FRRO office (BKC, Mumbai)
- Documents: Passport, visa, photos, address proof, employment letter
- Biometrics taken

### Dependents
- Can apply for Entry Visa (X Visa)
- Spouse: Can work with permission
- Children: Can study

---

## OCI (Overseas Citizen of India)

### Who Can Apply
- Former Indian citizens
- Spouse of Indian/OCI
- Children of OCI holders
- Indian-origin persons (some restrictions by country of citizenship)

### Benefits
- Lifetime validity
- Multiple entry
- Live and work in India freely
- No FRRO registration needed
- Buy property (with restrictions)
- Open bank accounts easily

### Restrictions
- Cannot vote
- Cannot hold government jobs
- Cannot buy agricultural land
- Must register if staying >180 days continuously

### Process
1. Apply at Indian embassy/VFS
2. Documents:
   - Proof of Indian origin (old passport, birth certificate, parents' documents)
   - Current passport
   - Photos
3. Processing: 1-3 months
4. Receive OCI card + stamp in passport

### Cost
$275-300 (varies by country)

---

## Student Visa

### For
- Full-time students at recognized Indian institutions
- Minimum 1 year course typically

### Requirements
- Admission letter from institution
- Financial proof
- Academic records

### Duration
- Length of course + 2-3 months
- Renewable

### Work
- Limited part-time work allowed
- Internships related to study allowed

---

## Visa Extensions

### General Rule
- Most visas cannot be extended in India
- Must exit and reapply

### Exceptions
| Visa | Extension Possible |
|------|-------------------|
| Employment | Yes, through FRRO |
| Student | Yes, with institution support |
| Medical | Yes |
| Tourist | Very difficult |
| OCI | Lifetime, no extension needed |

### Emergency Extensions
- Medical emergencies
- Natural disasters
- Apply at FRRO with documentation

---

## Registration Requirements

### Who Must Register (FRRO)
- Employment visa holders
- Student visa holders
- Any visa >180 days
- Research visa holders

### Timeline
- Within 14 days of arrival
- Missing deadline = problems

### FRRO Mumbai Location
- Bandra Kurla Complex
- Online appointment system
- Can be time-consuming

---

## Tax Implications

### Residential Status
| Days in India | Status | Taxation |
|---------------|--------|----------|
| <60 days | Non-resident | India income only |
| 60-182 days | Varies | Complex rules |
| >182 days | Resident | Worldwide income |

### For NRIs
- NRE account: Foreign income, tax-free
- NRO account: Indian income, taxable
- Maintain bank accounts appropriately

---

## Work Permits

### No Separate Work Permit
India doesn't have separate work permits — the Employment Visa IS the work authorization.

### Changing Employers
- Need new visa sponsorship
- Exit and re-enter typically required
- Or apply for visa transfer (complex)

### Freelancing
- Employment visa for specific employer
- Business visa doesn't allow
- OCI allows freelancing
- Gray area for many

---

## Common Issues

### Overstay
- Penalties: ₹300/day (approx)
- Can lead to deportation
- Affects future applications
- Avoid at all costs

### Visa Rejection
Common reasons:
- Incomplete documents
- Insufficient funds shown
- Inconsistent information
- Previous violations
- Security concerns

### Lost Passport
1. Report to police
2. Contact embassy
3. Get emergency travel document
4. Exit India with documentation

---

## Useful Contacts

| Service | Contact |
|---------|---------|
| FRRO Mumbai | indianfrro.gov.in |
| e-Visa portal | indianvisaonline.gov.in |
| VFS India | vfsglobal.com/india |
| Embassy locator | indiaportal.gov.in |
| Immigration helpline | 1800-111-363 |

---

## Timeline Summary

| Action | Time |
|--------|------|
| e-Visa (tourist) | 2-4 days |
| Business visa | 5-10 days |
| Employment visa | 2-4 weeks |
| OCI card | 1-3 months |
| FRRO registration | Same day (with appointment) |
| Visa extension | 2-4 weeks |

---

## Quick Reference

### Coming to Work
1. Get job offer
2. Apply for Employment Visa (2-4 weeks)
3. Arrive in India
4. Register with FRRO (within 14 days)
5. Get PAN card
6. Open bank account
7. Start working

### Coming as NRI/OCI
1. Apply for OCI if eligible (1-3 months)
2. Arrive in India
3. No registration needed (unless >180 days continuous)
4. Work, live freely

### Quick Visit
1. Apply for e-Visa (2-4 days)
2. Arrive
3. Explore
4. Leave before expiry
