# Mumbai Transport Guide

## Overview

Mumbai has the most complex transport system in India. The city was not designed for its current population, so expect crowding, delays, and creative solutions.

**Key insight**: Mumbai is LINEAR. North-south travel is easier than east-west.

---

## Local Trains — The Lifeline

### The System
- **7.5 million daily passengers** (one of world's busiest)
- **Three main lines**: Western, Central, Harbour
- **Hours**: ~4am to 1am (last trains around midnight)
- **Frequency**: Every 3-5 minutes during peak

### Lines Explained

#### Western Line (Purple)
- **Route**: Churchgate → Dahanu Road
- **Key stations**: Churchgate, Marine Lines, Mumbai Central, Dadar, Bandra, Andheri, Borivali
- **Best for**: North-south corridor along western coast

#### Central Line (Red)
- **Route**: CST → Kasara/Karjat
- **Key stations**: CST, Dadar, Kurla, Ghatkopar, Thane, Kalyan
- **Best for**: Eastern suburbs, connections to Pune

#### Harbour Line (Blue/Green)
- **Route**: CST → Panvel
- **Key stations**: CST, Kurla, Vashi, Belapur, Panvel
- **Best for**: Navi Mumbai, connections to airport (Vashi branch)

### Classes

| Class | Fare | Crowding | AC |
|-------|------|----------|-----|
| Second Class | ₹5-15 | Very crowded | No |
| First Class | ₹15-50 | Less crowded | No |
| AC Coaches (limited) | ₹60-150 | Comfortable | Yes |

**Women's compartment**: Dedicated coaches available, safer and less crowded.

### Peak Hour Reality

**Times to avoid**:
- **Morning rush**: 8:00-10:30 AM
- **Evening rush**: 5:30-8:30 PM

**What "crowded" means**: People literally hanging out of doors. Bodies pressed together. Getting on/off requires planning and force.

**Peak hour survival**:
- Position yourself near door before your station
- Keep belongings in front of body
- Women: Use ladies compartment
- Accept that you might miss a train
- Build buffer time into all plans

### Buying Tickets

**Token** (single journey):
- Buy at counter
- ₹5-50 depending on distance
- Long queues possible

**UTS App** (recommended):
- Book on phone
- Show QR code
- Shorter/no queues
- Requires bank account linkage

**Smart Card**:
- Rechargeable
- Tap at entry/exit
- Slight discount

### Useful Apps

| App | Purpose |
|-----|---------|
| m-Indicator | Best for schedules, routes |
| UTS | Mobile ticketing |
| Google Maps | General navigation |

---

## Metro

### Current Status
Mumbai Metro is expanding rapidly. Currently limited but useful.

**Operational Lines**:
| Line | Route | Status |
|------|-------|--------|
| Line 1 (Blue) | Versova-Ghatkopar | Running (31 km) |
| Line 2A | Dahisar-DN Nagar | Running |
| Line 7 | Dahisar E-Andheri E | Running |
| More lines | Various | Under construction |

### Line 1 (Most Useful)
Connects Western suburbs to Eastern suburbs:
- **Versova** → Andheri → Chakala → **Airport Road** → Marol → Saki Naka → **Ghatkopar**
- Air-conditioned, comfortable
- ₹10-40 per journey
- Connects Western Line (Andheri) to Central Line (Ghatkopar)

### Metro vs Trains
| Factor | Metro | Local Trains |
|--------|-------|--------------|
| Comfort | Air-conditioned | Hot, crowded |
| Coverage | Limited | Extensive |
| Crowding | Manageable | Intense at peak |
| Hours | 5:30am-11pm | 4am-1am |

---

## Auto Rickshaws

### Where They Operate
- **Suburbs only**: Not allowed in South Mumbai (island city)
- North of Bandra on Western side
- North of Sion on Central/Harbour side

### Fares
- **Meter**: ₹21 for first 1.5km, ₹15/km after
- **Reality**: Many refuse meter; negotiate or use apps
- **Night charges**: 25% extra after midnight

### Apps for Auto
- **Uber Auto**: Fixed price, reliable
- **Ola Auto**: Same as Uber Auto
- **Rapido**: Bike taxis (controversial legality)

### Tips
- Always ask for meter first
- Have destination on Google Maps to show
- Carry small change
- Learn to say "meter se chaloge?" (will you go by meter?)

---

## Taxis

### Black & Yellow
- **Mumbai's iconic taxis**
- Older cars, usually no AC
- Meter-based (₹22 minimum, ₹15/km after)
- Declining in numbers

### Blue/Silver Taxis (Cool Cabs)
- Air-conditioned
- Higher tariff (1.5x approximately)
- More comfortable

### App-Based (Recommended)
| App | Best For | Notes |
|-----|----------|-------|
| Uber | Reliability | Most cars |
| Ola | Coverage | Good alternative |
| Blu Smart | Electric, reliable | Growing fleet |

**Fares**: ₹100-500+ depending on distance
**Surge**: Common during rain and peak hours

---

## Buses (BEST)

Mumbai's bus network is extensive but slow.

### Overview
- **Operator**: BEST (Brihanmumbai Electric Supply & Transport)
- **Coverage**: Entire city
- **Fares**: ₹5-25
- **AC buses**: Available on some routes, ₹15-50

### When to Use
- Short trips within area
- Night service (limited routes run late)
- Connecting to train stations
- When trains are too crowded

### App
BEST app shows routes and live tracking.

---

## Ride-Hailing Tips

### General
- **Always verify**: Car number before getting in
- **Share trip**: With trusted contacts
- **Cash works**: If card fails
- **Surge pricing**: Common during rain, morning/evening rush

### During Monsoon
- Prices spike significantly
- Wait times increase
- Some drivers cancel frequently
- Have backup plans

### Late Night
- Auto-select gender (Uber/Ola have safety features)
- Share live location
- Safer than flagging random vehicles

---

## Special Transport

### Ferries
- **Gateway to Elephanta**: Tourist ferries daily
- **Gateway to Alibaug**: Ro-Ro ferry (cars + passengers)
- **Gateway to Mandwa**: Fast catamaran to Alibaug

### Monorail
- Limited utility (Chembur-Jacob Circle)
- Less crowded but doesn't connect to much
- Tourist curiosity more than practical

### Airport Transfer

| From | To Airport | Time (non-peak) | Time (peak) |
|------|------------|-----------------|-------------|
| South Mumbai | T2 | 45-60 min | 90-150 min |
| Bandra | T2 | 25-40 min | 60-90 min |
| Andheri | T2 | 15-25 min | 45-60 min |
| Powai | T2 | 30-45 min | 60-90 min |
| Juhu | T2 | 15-25 min | 45-60 min |

**Always add buffer for airport trips**

---

## Traffic Reality

### Worst Times
- **Morning**: 8:30-11:00 AM
- **Evening**: 5:30-9:00 PM
- **Monsoon**: Any time during heavy rain

### Worst Routes
- Western Express Highway
- Eastern Express Highway
- Bandra-Worli Sea Link (congested at entry/exit)
- JVLR (always)
- SV Road in suburbs

### Survival Strategies
1. **Trains for long distances**: Always faster
2. **Start early**: 8 AM meeting? Leave by 6:30 AM.
3. **Night travel**: After 10 PM, roads are empty
4. **Sunday**: Best day to drive
5. **Remote work**: If possible, avoid daily commute

---

## Navigation Apps

| App | Best For |
|-----|----------|
| Google Maps | General navigation, traffic |
| m-Indicator | Train schedules, routes |
| Uber/Ola | Booking rides |
| BEST app | Bus routes |
| Citymapper | Multi-modal planning |

---

## Transport by Area

### South Mumbai
- No autos
- Taxis plentiful
- Walking often fastest
- Trains to suburbs

### Bandra/Western Suburbs
- Autos available
- Good train connectivity
- Traffic bad on roads

### Powai
- No direct train
- Uber dependent
- JVLR connects to highways

### Navi Mumbai
- Harbour Line trains
- Autos throughout
- Less traffic than Mumbai

---

## Common Journeys

| From | To | Best Mode | Time |
|------|-----|-----------|------|
| Airport | South Mumbai | Taxi/Uber | 60-90 min |
| Airport | Bandra | Taxi | 30-45 min |
| Churchgate | Bandra | Train | 25 min |
| CST | Thane | Train | 50 min |
| Andheri | Ghatkopar | Metro | 35 min |
| Bandra | BKC | Auto/Uber | 15-20 min |
| Powai | Andheri | Uber | 25-35 min |

---

## Monsoon Transport

### Challenges
- **Waterlogging**: Roads and tracks flood
- **Train delays**: Tracks submerge
- **Traffic gridlock**: Entire city can halt
- **Higher fares**: Surge pricing everywhere

### Survival Tips
1. Check weather before leaving
2. Have multiple route options
3. Keep phone charged
4. Carry umbrella always
5. Wear waterproof footwear
6. Accept delays as part of life
7. Consider working from home on heavy rain days

---

## Cost Summary

| Mode | Typical Cost | Best For |
|------|--------------|----------|
| Local train | ₹10-40 | Commuting, long distances |
| Metro | ₹10-40 | Cross-city (where available) |
| Auto | ₹20-150 | Short suburb trips |
| Taxi (app) | ₹150-500+ | Comfort, door-to-door |
| Bus | ₹5-25 | Budget, short hops |

**Monthly transport budget**: ₹3,000-10,000 depending on lifestyle and commute
