# Mumbai Startup Ecosystem

## Overview

Mumbai's startup scene is **different from Bangalore**:
- Stronger in fintech, D2C, enterprise
- More bootstrapping culture
- Finance industry influence
- Fewer pure tech startups, more business-model innovation

---

## Key Sectors

### Fintech (Mumbai's Strength)
- Payment gateways
- Lending platforms
- Insurtech
- Wealthtech
- Trading platforms

**Notable**: Zerodha, Groww, CRED, Razorpay, PhonePe (operations)

### D2C (Direct to Consumer)
- Fashion and beauty
- Food and beverages
- Home and lifestyle

**Notable**: Mamaearth, Sugar Cosmetics, The Whole Truth

### Enterprise/B2B
- SaaS products
- Logistics tech
- HR tech
- Supply chain

### Media & Entertainment
- OTT platforms
- Content creation
- Gaming

---

## Funding Landscape

### Active Investors in Mumbai

| Investor | Type | Stage | Focus |
|----------|------|-------|-------|
| Sequoia | VC | All stages | Generalist |
| Accel | VC | Early-growth | Tech |
| Kalaari | VC | Early | Consumer |
| Matrix Partners | VC | Early | Consumer, fintech |
| Tiger Global | VC | Growth | Generalist |
| Blume Ventures | VC | Seed-A | Tech |
| India Quotient | VC | Seed | Consumer |
| Lightspeed | VC | Early-growth | Tech |

### Angel Networks
- Mumbai Angels
- Indian Angel Network (IAN)
- AngelList India
- LetsVenture

### Accelerators & Incubators
| Program | Focus | Benefits |
|---------|-------|----------|
| SINE (IIT Bombay) | Tech | Space, mentorship, network |
| Zone Startups | Multiple | Funding, mentorship |
| Axilor | Early stage | Funding, support |
| Startup India Hub | All | Government support |

---

## Startup India Benefits

### DPIIT Recognition
Register at startupindia.gov.in

**Benefits:**
- Tax exemption (3 years in first 10)
- Self-certification for labor laws
- Fast-track patent applications
- Easier public procurement
- No Angel Tax (up to ₹25 Cr)

### How to Register
1. Incorporate company
2. Register on Startup India portal
3. Apply for DPIIT recognition
4. Submit documents (pitch, incorporation cert)
5. Approval in 2-5 days

---

## Starting Up in Mumbai

### Costs

| Item | One-time Cost | Monthly Cost |
|------|---------------|--------------|
| Company registration | ₹15,000-30,000 | — |
| Virtual office (address) | ₹20,000/year | — |
| Co-working seat | — | ₹8,000-20,000 |
| CA/Compliance | — | ₹10,000-25,000 |
| Bank account | Free | — |
| Total (bootstrapped) | ~₹50,000 | ₹20,000-50,000 |

### Legal Essentials
1. **Founders' agreement**: Split, vesting, roles
2. **IP assignment**: To company, not individuals
3. **ESOP pool**: Set aside early (10-15%)
4. **Standard contracts**: Employment, NDA, services

### Co-working Recommendations

| Space | Monthly | Best For |
|-------|---------|----------|
| 91Springboard | ₹8,000-15,000 | Early startups |
| WeWork | ₹15,000-30,000 | Funded startups |
| Awfis | ₹8,000-15,000 | Budget-friendly |
| WorkVista | ₹6,000-12,000 | Very early |

---

## Hiring for Startups

### Where to Find Talent
- AngelList (startup-minded)
- LinkedIn
- IIT placement (expensive but quality)
- Referrals (best)
- Internships → full-time

### Typical Startup Salaries

| Role | Range (₹ LPA) | + ESOP |
|------|---------------|--------|
| Full-stack developer | 12-30 | 0.1-1% |
| Product manager | 18-40 | 0.1-0.5% |
| Designer | 10-25 | 0.1-0.3% |
| Operations | 8-20 | 0.1-0.3% |
| Sales | 10-25 + variable | 0.1-0.3% |

### ESOP Best Practices
- 4-year vesting, 1-year cliff
- Standard in term sheets (10-15% pool)
- Document properly (409A equivalent)

---

## Networking

### Events
- TiE Mumbai events
- Nasscom events
- Product Tank Mumbai
- Startup Grind (occasional)

### Communities
- WhatsApp groups (ask for intros)
- LinkedIn Mumbai Startups
- Twitter startup community

### Key People to Know
- Follow active angels on Twitter
- Attend demo days
- Connect with other founders

---

## Mumbai vs Bangalore for Startups

| Factor | Mumbai | Bangalore |
|--------|--------|-----------|
| Fintech | Stronger | Good |
| Pure tech | Fewer | More |
| Talent pool | Good | Better for tech |
| Cost | Higher (rent) | Lower |
| Funding | Good | Better |
| Ecosystem | Maturing | Mature |
| Government support | Good | Good |
| Networking | Finance-oriented | Tech-oriented |

### When Mumbai is Better
- Fintech (proximity to banks, regulators)
- D2C (media, marketing)
- Enterprise (corporate customers)
- Bootstrapping (finance mindset)

### When Bangalore is Better
- Deep tech
- SaaS
- Developer tools
- Need tech talent at scale

---

## Fundraising

### Process
1. **Pre-seed/Angel**: ₹50L-2Cr
   - Angels, family offices
   - Convertible notes common
   
2. **Seed**: ₹2-10Cr
   - Micro VCs, seed funds
   - Priced round or SAFE

3. **Series A**: ₹20-80Cr
   - Institutional VCs
   - Priced round

### What VCs Look For
- Founding team
- Market size
- Traction/metrics
- Differentiation
- Unit economics path

### Term Sheet Essentials
- Valuation (pre/post money)
- Liquidation preference
- Board composition
- Pro-rata rights
- Vesting schedules

---

## Exits

### Exit Options
1. **Acquisition**: Most common for Mumbai startups
2. **IPO**: Increasing (SME exchanges, main board)
3. **Secondary sales**: Liquidity events

### Recent Mumbai Exits
- Nykaa IPO
- PolicyBazaar IPO
- Multiple D2C acquisitions

---

## Resources

### Must-Read
- Inc42 (startup news)
- Entrackr (funding news)
- YourStory (startup stories)
- Ken (business deep-dives)

### Tools
- Razorpay (payments)
- Zoho (everything)
- Freshworks (CRM, support)
- Instamojo (simple payments)

### Government Resources
- Startup India portal
- SIDBI (loans)
- State startup policy

---

## Quick Start Guide

### Week 1-2
- Incorporate (use CA/lawyer)
- Open bank account
- Get virtual/coworking address

### Month 1
- Startup India registration
- Build MVP
- Validate with customers
- Set up basic analytics

### Month 2-3
- Iterate on product
- Get first paying customers
- Document everything
- Start networking

### Month 4-6
- Prove unit economics
- Build team (2-3 people)
- Start thinking about funding (if needed)
- Focus on growth metrics
