# Mumbai Safety Guide

## Overall Safety

Mumbai is **relatively safe** for a megacity of 20+ million people. Violent crime against foreigners is rare. The main concerns are petty theft, scams, and traffic.

**Safety ranking**: One of India's safest large cities
**24/7 nature**: City is alive at all hours — people around most places most times

---

## Crime & Personal Safety

### Low Risk
- Violent crime against foreigners
- Mugging with weapons
- Kidnapping
- Gang violence (unless in specific areas)

### Medium Risk
- Pickpocketing (crowded trains, markets)
- Bag snatching (motorcycle-borne)
- Phone theft
- Scams

### Areas to Be Cautious
| Area | Concern | Time |
|------|---------|------|
| Train stations | Pickpockets | Rush hour |
| Tourist spots | Scams | Any time |
| Dharavi | Get guide | Any time |
| Red light areas (Kamathipura) | Various | Night |
| Isolated areas | Theft | Night |

### Safe Areas
- Most residential neighborhoods
- Hotel areas
- Malls
- Business districts
- Major streets

---

## Women's Safety

Mumbai is **among the safest Indian cities for women** but still requires awareness.

### Tips
1. **Dress code**: Modest dress reduces unwanted attention
2. **Train compartments**: Use women's coaches (less crowded, safer)
3. **Avoid empty streets**: Especially at night
4. **Share location**: With trusted contacts
5. **Stay alert**: Headphones off in isolated areas
6. **Trust instincts**: Leave uncomfortable situations

### Transport Safety
- **Uber/Ola**: Share trip feature, verify car number
- **Autos**: Use apps over flagging
- **Trains**: Women's compartment is much better
- **Walking**: Main roads preferable to back lanes

### What's Generally Fine
- Eating out alone
- Shopping in markets
- Daytime exploring
- Public spaces
- Business meetings

### Nightlife
- Stick to known venues
- Leave with friends
- Pre-book transport home
- Avoid isolated club exits

---

## Health & Environmental

### Water
- **NEVER drink tap water**
- Bottled water only
- Check seal is intact
- Restaurants: Filtered water usually safe
- Ice: Safe in good restaurants only

### Air Quality
- **Poor to moderate** most days
- Worse in winter (Dec-Jan)
- Better during monsoon
- Consider mask on very bad days
- AQI apps: IQAir, AirVisual

### Food Safety
- Eat at high-turnover places
- Cooked food safest initially
- Street food: Build tolerance slowly
- Avoid raw salads from basic places

### Monsoon Hazards
| Risk | Prevention |
|------|------------|
| Waterborne diseases | Purified water only |
| Leptospirosis | Avoid walking in floods |
| Dengue/malaria | Mosquito repellent |
| Waterlogged roads | Avoid open sewers |
| Traffic accidents | Extra caution |

### Medical Emergencies
- **Hospitals**: See `healthcare.md` for recommended
- **Ambulance**: 102 or 108
- **Private**: Most hospitals have 24/7 ER
- **Pharmacies**: Well-stocked, many OTC medicines

---

## Traffic Safety

### The Reality
- Traffic rules are suggestions
- Pedestrians do not have right of way
- Crossing roads requires strategy
- Accidents are common

### Survival Rules
1. **Never assume cars will stop**
2. **Cross with locals** — follow their lead
3. **Use crossings when available**
4. **Make eye contact with drivers**
5. **Cross in groups**
6. **Assume all vehicles are moving**

### As a Pedestrian
- Footpaths often blocked (vendors, bikes)
- Roads in bad condition
- Watch for potholes, open drains
- Monsoon: Flooded areas hide hazards

### As a Passenger
- Always use seatbelt (even if driver doesn't)
- Sit in back seat of taxis
- Hold on — jerky driving is normal
- Don't panic (experienced drivers)

---

## Natural Disasters

### Monsoon Flooding
- **When**: June-September
- **Impact**: Roads, trains, normal life disrupted
- **Survival**: Stay home during heavy rain, avoid low-lying areas

### Cyclones
- **Risk**: Occasional, Arabian Sea
- **Warning**: Usually adequate advance notice
- **Action**: Follow municipal advisories

### Earthquakes
- **Risk**: Low (not in active seismic zone)
- **Old buildings**: May not be earthquake-resistant

---

## Scams & Fraud

### Common Tourist Scams

| Scam | How It Works | Prevention |
|------|--------------|------------|
| Taxi meter "broken" | Overcharge you | Insist on meter or use app |
| "Hotel closed" | Take you to commission hotel | Book ahead, verify |
| Fake guides | Charge heavily, give bad info | Use official guides |
| Gem scam | Sell fake gems as investment | Don't buy gems |
| Photography fee | Charge for photos with props | Agree price first |
| "Free" boat rides | Ask for money after | Avoid |

### Street Scams
- Sob stories asking for money
- "Dropped" money trick
- Fake charity collection
- Friendly stranger leading to shop

### Digital Scams
- Fake delivery OTPs (never share)
- Lottery/prize scams
- QR code payment fraud
- Fake UPI requests

---

## Emergency Numbers

| Service | Number |
|---------|--------|
| Police | 100 |
| Ambulance | 102 or 108 |
| Fire | 101 |
| Women's helpline | 1091 |
| Tourist helpline | 1800-111-363 |
| Road accident | 1073 |
| Anti-corruption | 1031 |

### Police Stations
- Every area has a local police station
- Tourist police at major tourist areas
- Crime branch for serious matters

### Embassies/Consulates
- US: +91-22-2672-4000
- UK: +91-22-6650-2222
- Australia: +91-22-6757-4900
- Canada: Nearest in Delhi

---

## Safety by Time of Day

### Daytime (6am - 6pm)
- Very safe
- Crowds everywhere
- Normal urban caution

### Evening (6pm - 10pm)
- Generally safe
- Busiest transport times
- Well-lit main areas

### Night (10pm - Midnight)
- Main areas still active
- More caution needed
- Stick to known areas

### Late Night (Midnight - 6am)
- Quieter streets
- Stay in groups
- Use app-based transport
- Major commercial areas still have activity

---

## Legal Considerations

### Drug Laws
- **Zero tolerance**
- Possession of any amount = serious offense
- Prison sentences for small quantities
- Don't joke about it at airports

### Alcohol Laws
- Legal age: 25 years
- Licensed venues only
- No public drinking
- DUI laws enforced

### Photography
- **Restricted**: Airports, military installations, govt buildings
- **Permitted**: Most tourist sites
- **People**: Ask permission
- **Religious sites**: Often restricted inside

### Other Laws
- Smoking banned in public places
- Jaywalking (rarely enforced but risky)
- Traffic violations (fines)
- Loud noise after 10pm (complaints possible)

---

## Safety Technology

### Useful Apps
| App | Purpose |
|-----|---------|
| 112 India | Emergency SOS |
| Women safety apps | Various local options |
| Uber/Ola | Trip sharing |
| Google Maps | Navigation, sharing location |
| WhatsApp | Location sharing |

### Phone Setup
- Emergency contacts saved
- Medical info on lock screen
- Location sharing enabled
- Important numbers offline

---

## Insurance Recommendations

- **Travel insurance**: For visitors (medical + evacuation)
- **Health insurance**: For residents (see `healthcare.md`)
- **Consider covering**:
  - Medical emergencies
  - Theft
  - Trip cancellation
  - Emergency evacuation

---

## Cultural Safety

### Avoiding Offense
- Dress modestly in religious places
- Remove shoes when required
- Don't point feet at people/deities
- Don't photograph without permission
- Respect local customs

### Political Safety
- Avoid protests/demonstrations
- Don't discuss controversial topics loudly
- Kashmir, religion, politics = sensitive
- Social media posts can have consequences

---

## Summary Tips

1. **Mumbai is safe** — but stay aware
2. **Biggest risks**: Traffic, scams, petty theft — not violence
3. **Use technology**: Apps for transport, location sharing
4. **Trust locals**: Most people are genuinely helpful
5. **Common sense applies**: Same as any major city
6. **Night out**: Group up, pre-book transport, share location
7. **Monsoon**: Extra caution needed
8. **Health**: Water + food safety crucial first weeks
