# Moving to Mumbai — Resident Guide

## First Steps Checklist

### Before Arrival
- [ ] Visa sorted (see `visas.md`)
- [ ] Short-term accommodation (1-2 weeks minimum)
- [ ] Cash in INR (ATM limits exist)
- [ ] Phone with Indian SIM (get at airport)
- [ ] Key documents (passport copies, photos, address proof from home)

### First Week
- [ ] SIM card with data (Jio or Airtel)
- [ ] Bank account (or know limitations without one)
- [ ] Understand local train system
- [ ] Uber/Ola set up
- [ ] Explore 2-3 neighborhoods

### First Month
- [ ] Find housing
- [ ] Register with FRRO (if staying >180 days)
- [ ] Aadhaar card application (if eligible)
- [ ] PAN card (if working/earning)
- [ ] Set up UPI payments
- [ ] Find your routine spots (gym, grocery, etc.)

---

## Finding Housing

### The Process

1. **Define budget and area** (see `neighborhoods-*.md`)
2. **Search methods**:
   - Broker (most common)
   - 99acres, MagicBricks, Housing.com
   - Facebook groups (good for shared housing)
   - NoBroker (reduced/no brokerage)
3. **View apartments** (always in person)
4. **Negotiate terms**
5. **Sign agreement**
6. **Pay deposit + advance rent + brokerage**
7. **Move in**

### Costs Breakdown

| Item | Amount | Notes |
|------|--------|-------|
| Security deposit | 2-6 months rent | Negotiable, typically 3 |
| Brokerage | 1-2 months rent | To broker, sometimes negotiable |
| Advance rent | 1 month | First month upfront |
| Rent agreement | ₹1,000-3,000 | Registration fees |
| Society deposit | ₹10,000-50,000 | Some buildings require |

**Total upfront**: 5-10 months rent equivalent

### Negotiation Tips

- **Deposit**: Always negotiate down from 6 months
- **Brokerage**: NoBroker avoids this; otherwise, try for 15 days
- **Rent**: 5-10% reduction often possible
- **Maintenance**: Clarify what's included
- **Furnishing**: Negotiate appliances (AC, geyser, washing machine)

### Red Flags

- Landlord doesn't want formal agreement
- Excessive deposit demands
- Building has water/power issues (ask neighbors)
- Unclear maintenance charges
- Area floods in monsoon (research!)

### Furnished vs Unfurnished

| Type | Rent Premium | Includes |
|------|--------------|----------|
| Unfurnished | Base | Empty, maybe kitchen |
| Semi-furnished | +20-30% | AC, beds, basic furniture |
| Fully furnished | +40-60% | Everything, ready to move |

**Expat tip**: Start semi/fully furnished, then decide if you want to furnish your own place later.

---

## Bank Account

### For Residents/Workers
**Requirements**:
- Passport
- Visa
- Address proof (rental agreement or utility bill)
- PAN card (can apply simultaneously)
- Passport photos

**Recommended banks**:
- HDFC Bank (most foreigner-friendly)
- ICICI Bank (good digital banking)
- Kotak Mahindra (modern, good app)

**Account types**:
- Savings account (standard)
- NRE/NRO account (for NRIs — different rules)

### Without Bank Account (Short-term)
- Wise (TransferWise) card
- International cards (work in most places)
- Withdrawal limits at ATMs
- Some UPI limitations

### UPI (Unified Payments Interface)
India's payment revolution. Essential.

**How it works**:
- Link bank account to phone number
- Pay via QR code or phone number
- Instant transfer
- Works everywhere (street vendors to malls)

**Apps**: Google Pay, PhonePe, Paytm

---

## SIM Card & Phone

### Getting a SIM
- **Airport**: Counters at arrival (convenient)
- **Stores**: Jio, Airtel, Vi stores
- **Requirements**: Passport, visa, photo, local address (hotel works initially)
- **Activation**: Can take 1-24 hours

### Best Operators
| Operator | Strength | Notes |
|----------|----------|-------|
| Jio | Coverage, price | Newer network, aggressive pricing |
| Airtel | Reliability | Oldest, most established |
| Vi (Vodafone-Idea) | Okay | Struggling financially |

### Typical Plans
- Prepaid: ₹200-500/month for data + calls
- Postpaid: ₹500-1,000/month for premium plans
- Data: 1.5-3 GB/day usually included

---

## Registration (FRRO)

### Who Needs to Register
- Foreigners staying >180 days on any visa
- Employment visa holders
- Student visa holders

### Process
1. Online registration at indianfrro.gov.in
2. Document upload
3. Appointment at FRRO office (BKC for Mumbai)
4. Biometrics and verification
5. Registration certificate issued

### Documents Needed
- Passport
- Visa
- Passport photos
- Address proof
- Employment letter (if applicable)
- Sponsorship letter from employer

**Timing**: Do this early — backlogs exist

---

## Essential Documents

### Aadhaar Card
India's biometric ID. Not mandatory for foreigners but useful.
- Makes many things easier (SIM, bank, etc.)
- Foreigners on long-term visas can apply
- Process: Aadhaar center appointment → biometrics → card mailed

### PAN Card
Tax ID number. Needed for:
- Opening bank account
- Any financial transactions over ₹50,000
- Working legally
- Tax filing

Apply at: tin.tin.nsdl.com

---

## Getting Around — Initial Period

### Uber/Ola
Set up immediately. Works with international cards initially.
- Download both apps
- Link payment method
- Much easier than negotiating with autos

### Local Trains
Will need to learn eventually. Start with off-peak times.
- Buy token at station (₹10-20)
- Or get smart card (not essential initially)
- Western Line or Central Line depending on location

### Metro
Easy, air-conditioned, less crowded.
- Token-based
- Line 1: Versova-Ghatkopar (useful)
- More lines coming

---

## Healthcare Setup

### Health Insurance
- If employed: Company usually provides
- If self-employed: Buy private policy
- International insurance: Can work but check coverage
- Good companies: HDFC Ergo, ICICI Lombard, Star Health

### Finding Doctors
- Hospital-affiliated doctors (safest)
- Practo app (doctor discovery)
- Recommendations from expat community

### Pharmacies
- Apollo, MedPlus, Guardian: Large chains
- Neighborhood pharmacies: Common, reliable
- Many medicines OTC that require prescription elsewhere

### Recommended Hospitals
- **Breach Candy Hospital** (South Mumbai)
- **Lilavati Hospital** (Bandra)
- **Kokilaben Hospital** (Andheri)
- **Hinduja Hospital** (Mahim)
- **Bombay Hospital** (Marine Lines)

---

## Settling In — Services

### Electricity
- Existing connection in apartments
- Transfer to your name via utility portal
- Prepaid meters in some areas
- Bills: Online or at centers

### Gas (Cooking)
- Piped gas (PNG) available in many areas
- LPG cylinders where PNG not available
- Register with local gas agency

### Internet
- **JioFiber**: Good speeds, value
- **Airtel Xstream**: Reliable
- **ACT Fibernet**: Good in coverage areas
- **Tata Play Fiber**: Decent

Speeds: 100 Mbps+ plans available ₹500-1,000/month

### Water
- Municipal supply (timing varies by area)
- Tank storage common
- Don't drink tap water!

---

## Expat Community

### Finding Your People
- **InterNations Mumbai**: Events, networking
- **Facebook groups**: Mumbai Expats, nationality-specific groups
- **Sports clubs**: Cricket, running clubs, gyms
- **Co-working spaces**: WeWork, 91Springboard
- **Embassy events**: Cultural events, national days

### Common Expat Areas
- Bandra (largest expat concentration)
- Powai (tech workers)
- South Mumbai (diplomats, old-timers)
- Lower Parel (corporate expats)

---

## Cost of Living (Monthly)

### Single Person, Comfortable

| Category | Amount (₹) | Amount ($) |
|----------|------------|------------|
| Rent (1BHK Bandra) | 50,000-70,000 | 600-840 |
| Utilities | 3,000-5,000 | 36-60 |
| Internet/phone | 1,500-2,000 | 18-24 |
| Groceries | 8,000-12,000 | 96-144 |
| Eating out | 10,000-20,000 | 120-240 |
| Transport | 5,000-10,000 | 60-120 |
| Entertainment | 5,000-10,000 | 60-120 |
| **Total** | 82,500-1,29,000 | 990-1,548 |

### Family of Four, Comfortable

| Category | Amount (₹) | Amount ($) |
|----------|------------|------------|
| Rent (3BHK Powai) | 80,000-1,20,000 | 960-1,440 |
| Utilities | 6,000-10,000 | 72-120 |
| School fees (per child/year) | 5-15 LPA | 6K-18K |
| Groceries | 20,000-30,000 | 240-360 |
| Help (maid/cook) | 15,000-25,000 | 180-300 |
| Transport | 15,000-25,000 | 180-300 |
| **Total (excl school)** | 1,36,000-2,10,000 | 1,632-2,520 |

---

## First Month Survival Tips

1. **Stay flexible on housing**: Don't sign long lease immediately
2. **Learn train system**: Weekend practice runs
3. **Accept help**: Indians are generally helpful to newcomers
4. **Prepare for bureaucracy**: Nothing is fast
5. **Get a routine**: Find your coffee spot, gym, grocery store
6. **Be patient with yourself**: Culture adjustment takes time
7. **Embrace the chaos**: Mumbai is intense but rewarding
8. **Connect with expats AND locals**: Both networks are valuable
9. **Document everything**: Keep copies of all papers
10. **Enjoy the food**: This is where Mumbai really shines
