# Mumbai Local Services Guide

## Banking

### Opening an Account
**For Residents/Workers:**
- Passport + visa
- Address proof (rental agreement, utility bill)
- PAN card (or form 60)
- Passport photos

**Recommended Banks:**
| Bank | Pros | Cons |
|------|------|------|
| HDFC Bank | Foreigner-friendly, great app | Sometimes slow service |
| ICICI Bank | Good digital banking | Variable branch quality |
| Kotak Mahindra | Modern, responsive | Fewer branches |
| Axis Bank | Good savings accounts | — |
| SBI | Everywhere, government | Bureaucratic |

### NRE/NRO Accounts (for NRIs)
- **NRE**: Foreign income, fully repatriable, tax-free
- **NRO**: Indian income, limited repatriation, taxable
- Consult bank for specifics

### Digital Payments (UPI)
Essential in India. Works everywhere.

**How it works:**
1. Link bank account to phone number
2. Create UPI ID (yourname@bankname)
3. Scan QR or enter UPI ID to pay
4. Instant transfer

**Apps:**
- Google Pay (most popular)
- PhonePe (popular)
- Paytm (older, still used)
- Bank apps (HDFC, ICICI have built-in)

**UPI usage:**
- Street vendors to luxury stores
- Bill payments
- Train tickets
- Peer-to-peer transfers

---

## SIM Card & Mobile

### Getting a SIM
**Airport (Easiest):**
- Counters at arrival (Jio, Airtel)
- Need: Passport, visa, photo
- Takes: 30 min to 24 hours activation

**Store:**
- Jio/Airtel stores everywhere
- Same documents
- May be faster activation

### Best Operators
| Operator | Strength | Network |
|----------|----------|---------|
| Jio | Cheap, good data | 4G/5G excellent |
| Airtel | Reliable, good customer service | Best overall |
| Vi | Okay | Struggling network |

### Typical Plans
| Type | Cost/month | Data | Calls |
|------|------------|------|-------|
| Basic prepaid | ₹200-300 | 1.5GB/day | Unlimited |
| Mid prepaid | ₹400-500 | 2GB/day | Unlimited |
| Premium prepaid | ₹600-900 | 3GB/day | Unlimited |
| Postpaid | ₹500-1500 | 50-150GB | Unlimited |

### International Roaming
- Expensive on Indian SIMs
- Buy local data packs before travel
- Or use eSIM/international plans

---

## Internet & WiFi

### Home Internet
| Provider | Speed | Cost/month | Notes |
|----------|-------|------------|-------|
| JioFiber | 30-1000 Mbps | ₹399-8,499 | Good value |
| Airtel Xstream | 40-1000 Mbps | ₹499-9,999 | Reliable |
| ACT Fibernet | 40-1000 Mbps | ₹649-5,999 | Select areas |
| Tata Play Fiber | 50-500 Mbps | ₹699-2,499 | Growing |

**Reality:** 100 Mbps for ₹500-700/month is standard now

### Setup Time
- 3-7 days typically
- Sometimes longer in new areas

### WiFi in Public
- Most cafes have WiFi (ask for password)
- Malls: Usually available
- Airports: Free (limited) or paid
- Hotels: Usually included

---

## Electricity

### How It Works
- State electricity board (BEST/Adani)
- Existing connection in apartments
- Transfer to your name when moving in
- Smart meters in most areas

### Bills
- Monthly billing
- Pay online (app/website)
- Or at payment centers
- Auto-debit available

### Costs
| Usage | Monthly Bill |
|-------|--------------|
| Light use (no AC) | ₹500-1,500 |
| Normal (some AC) | ₹1,500-3,000 |
| Heavy (AC often) | ₹3,000-6,000 |
| Summer (AC always) | ₹5,000-10,000 |

### Power Cuts
- Rare in most of Mumbai
- More common in suburbs
- Monsoon: Can happen
- Most good buildings have backup

---

## Gas (Cooking)

### Piped Natural Gas (PNG)
- Available in most areas
- Mahanagar Gas (MGL) provider
- Apply online, installation ₹5,000-8,000
- Monthly: ₹200-800 depending on use

### LPG Cylinders
- Where PNG not available
- Register with HP/Indane/Bharat
- Cylinder delivery: ₹800-1,000
- Refill: Same price

---

## Water

### Municipal Supply
- Timing varies by area
- May be 1-2 hours morning/evening
- Storage tanks in all buildings
- Quality: Not drinkable!

### Drinking Water
- Water purifier essential (RO systems)
- Or buy bottled (expensive long-term)
- 20L can delivery: ₹30-60

---

## Groceries & Shopping

### Supermarkets
| Store | Type | Prices |
|-------|------|--------|
| DMart | Hypermarket | Cheapest |
| Big Bazaar | Hypermarket | Cheap |
| Reliance Fresh | Local grocer | Moderate |
| Spencer's | Supermarket | Moderate |
| Nature's Basket | Premium | Expensive |
| Foodhall | Gourmet | Very expensive |

### Delivery Apps
| App | Best For | Speed |
|-----|----------|-------|
| BigBasket | Weekly grocery | Scheduled slots |
| Blinkit | Quick items | 10-20 min |
| Zepto | Quick items | 10-15 min |
| Amazon Fresh | Regular grocery | 2-4 hours |
| Dunzo | Anything | 30-60 min |

### Local Markets
- **Crawford Market**: Wholesale, everything
- **Local mandis**: Vegetables, fruit (cheap)
- **Neighborhood stores**: Kirana shops everywhere

---

## Domestic Help

### Finding Help
- Society security desk (referrals)
- Neighbors (best source)
- Agencies (BookMyBai, Helper4U)
- Facebook groups

### Types & Rates

| Type | Work | Hours | Monthly (₹) |
|------|------|-------|-------------|
| Part-time maid | Cleaning, dishes | 1-2 hrs | 3,000-8,000 |
| Full-time maid | All household | 8+ hrs | 12,000-25,000 |
| Cook (part-time) | Cooking only | 1-2 hrs | 5,000-12,000 |
| Full-time cook | All meals | 4-6 hrs | 12,000-20,000 |
| Driver | Driving | 8-10 hrs | 15,000-25,000 |
| Nanny | Childcare | Full day | 15,000-30,000 |

### Tips
- Check references
- Trial period first
- Clear expectations upfront
- Festival bonus expected (1 month salary)
- Paid leave (festivals, emergencies)

---

## Laundry & Dry Cleaning

### Options
| Type | Cost | Notes |
|------|------|-------|
| Washing machine at home | ₹0 | Most common |
| Dhobi (traditional) | ₹20-50/piece | Ironing included |
| Laundry service | ₹40-80/kg | Pickup/delivery |
| Dry cleaning | ₹100-400/piece | For formal wear |
| Apps (Laundrokart, etc.) | Varies | Convenient |

---

## Medical Services

### Pharmacies
- Everywhere (every neighborhood)
- Many medicines OTC
- Chains: Apollo, MedPlus, Guardian
- Most open 9am-10pm (some 24/7)

### Doctors
- Hospital-affiliated (recommended)
- Private clinics
- Practo app (finding doctors)
- Consultation: ₹500-2,000

### Diagnostics
- Thyrocare, SRL, Metropolis (blood tests)
- Home collection available
- Basic blood work: ₹500-1,500

---

## Government Services

### Important Offices
| Service | Where |
|---------|-------|
| FRRO (foreigners registration) | BKC |
| Passport office | Bandra Kurla Complex |
| RTO (vehicle registration) | Multiple |
| Police stations | Every area |
| Municipal offices | Ward-wise |

### Key Documents
- Aadhaar: Apply at Aadhaar centers (need appointment)
- PAN: Online application
- Driving license: RTO (tests required)

---

## Transportation Cards

### Smart Cards
- **Mumbai 1 Card**: Integrated transport (trains, buses, metro)
- **National Common Mobility Card**: Works across cities

### Taxi/Auto Apps
- Uber: Most reliable
- Ola: Good alternative
- Rapido: Bike taxis

---

## Postal Services

### India Post
- Everywhere
- Reliable for documents
- Slow for packages
- Registered post: Proof of delivery

### Courier Services
| Service | Speed | Cost | Best For |
|---------|-------|------|----------|
| BlueDart | Fast | Higher | Documents |
| DTDC | Good | Moderate | Packages |
| Delhivery | Variable | Lower | E-commerce |
| FedEx/DHL | Fast | High | International |

---

## Important Apps to Have

| Category | App |
|----------|-----|
| Payments | Google Pay, PhonePe |
| Banking | Your bank's app |
| Transport | Uber, Ola, m-Indicator |
| Food delivery | Swiggy, Zomato |
| Groceries | BigBasket, Blinkit |
| Healthcare | Practo |
| Movies/Events | BookMyShow |
| Utilities | Provider apps |
| Maps | Google Maps |
| Communication | WhatsApp (essential) |

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| Police | 100 |
| Fire | 101 |
| Ambulance | 102/108 |
| Women's helpline | 1091 |
| Municipal disaster | 1916 |
| Electricity | 1912 (BEST) |
| Gas leak | 1800-233-8008 (MGL) |
