# Mumbai Healthcare Guide

## Healthcare System Overview

Mumbai has **excellent healthcare** — among the best in India:
- World-class private hospitals
- Medical tourism destination
- Good specialist availability
- Government hospitals for emergencies

---

## Hospital Tiers

### Tier 1: Premium Private
- International standards
- Most expensive
- All specialties
- English-speaking staff

### Tier 2: Good Private
- High quality
- Moderate cost
- Most specialties
- Good for most needs

### Tier 3: Budget Private
- Basic care
- Affordable
- Variable quality

### Government
- Free or very cheap
- Often overcrowded
- Good for emergencies
- JJ Hospital, KEM Hospital notable

---

## Top Hospitals

### Premium (₹₹₹₹)

| Hospital | Location | Specialty |
|----------|----------|-----------|
| Breach Candy | Breach Candy | General, elite |
| Kokilaben Dhirubhai Ambani | Andheri | Multi-specialty |
| Nanavati Max | Vile Parle | Multi-specialty |
| Lilavati | Bandra | Multi-specialty |
| Jaslok | Pedder Road | Multi-specialty |
| HN Reliance Foundation | Girgaum | Multi-specialty, new |

### Very Good (₹₹₹)

| Hospital | Location | Specialty |
|----------|----------|-----------|
| Hinduja | Mahim | Multi-specialty |
| Bombay Hospital | Marine Lines | Multi-specialty |
| Wockhardt | Multiple | Multi-specialty |
| Global Hospital | Parel | Multi-specialty |
| Saifee | Marine Lines | Multi-specialty |

### Good Value (₹₹)

| Hospital | Location | Notes |
|----------|----------|-------|
| Tata Memorial | Parel | Cancer (excellent) |
| SRCC Children's | Haji Ali | Pediatrics |
| Fortis | Multiple | Chain, reliable |
| Apollo | Multiple | Chain |

### Government (₹)

| Hospital | Location | Notes |
|----------|----------|-------|
| KEM Hospital | Parel | Best government |
| JJ Hospital | Byculla | Large, trauma |
| Sion Hospital | Sion | Burns, general |
| Nair Hospital | Central Mumbai | Good facility |

---

## Health Insurance

### For Employees
- Most companies provide group insurance
- Typical coverage: ₹3-5 lakh
- Top-up recommended for better hospitals

### For Self/Family

| Type | Annual Premium | Coverage |
|------|----------------|----------|
| Basic | ₹8,000-15,000 | ₹3-5 lakh |
| Standard | ₹15,000-30,000 | ₹10-15 lakh |
| Comprehensive | ₹30,000-60,000 | ₹25-50 lakh |
| Premium/International | ₹1,00,000+ | ₹1 Cr+ |

### Recommended Insurers
- HDFC Ergo
- ICICI Lombard
- Star Health
- Niva Bupa (formerly Max Bupa)
- Care Health

### What to Check
- Network hospitals
- Pre-existing disease waiting period
- Room rent limits
- No-claim bonus
- Cashless vs reimbursement

---

## Finding Doctors

### Methods
1. **Hospital-affiliated**: Most reliable
2. **Practo app**: Doctor discovery, reviews
3. **Referrals**: Ask locals, colleagues
4. **Google reviews**: Cross-check

### Consultation Fees

| Type | Fee Range |
|------|-----------|
| General physician | ₹500-1,000 |
| Specialist | ₹800-2,000 |
| Super-specialist | ₹1,500-3,000 |
| Premium hospital specialist | ₹2,000-5,000 |

### Booking
- Most hospitals: Online booking
- Practo: Book through app
- Direct call: Still works
- Walk-in: Possible but wait times vary

---

## Pharmacies

### Chains
- Apollo Pharmacy
- MedPlus
- Guardian (premium)
- Wellness Forever

### Availability
- Everywhere in city
- Most open 9am-10pm
- Some 24-hour options
- Near major hospitals: 24/7

### Buying Medicines
- Many available OTC
- Prescription needed for antibiotics, controlled substances
- Generic alternatives available (ask)
- Always check expiry

### Online Pharmacies
- PharmEasy
- 1mg
- Netmeds
- Amazon Pharmacy

---

## Emergency Services

### Emergency Numbers
| Service | Number |
|---------|--------|
| Ambulance | 102 or 108 |
| Police | 100 |
| Fire | 101 |

### Private Ambulance
- Hospital ambulances (call hospital directly)
- Medulance app
- StanPlus

### What to Do in Emergency
1. Call ambulance or hospital
2. Go to nearest emergency (don't always go to "best" hospital)
3. Carry insurance card
4. Keep emergency contacts on phone

---

## Diagnostic Services

### Labs
| Lab | Type | Home Collection |
|-----|------|-----------------|
| SRL Diagnostics | Comprehensive | Yes |
| Metropolis | Comprehensive | Yes |
| Thyrocare | Budget, good | Yes |
| Dr. Lal PathLabs | Good coverage | Yes |
| Hospital labs | When admitted | — |

### Imaging
- CT/MRI: Available at major hospitals
- X-ray: Widely available
- Ultrasound: Common
- Cost: ₹500-15,000 depending on test

### Home Collection
- All major labs offer
- Book online or call
- Slight premium
- Results online

---

## Specialist Care

### Finding Specialists
| Specialty | Where |
|-----------|-------|
| Cardiac | Kokilaben, Hinduja, Breach Candy |
| Cancer | Tata Memorial (best), Kokilaben |
| Orthopedic | Hinduja, Lilavati, Breach Candy |
| Pediatric | SRCC, Kokilaben, Lilavati |
| IVF | Nova, Jaslok, Mumbai Fertility |
| Dental | Clove, Apollo White |
| Eye | Sankara Nethralaya, Aditya Jyot |
| Mental health | iCall, private psychiatrists |

---

## Mental Health

### Resources
- **iCall**: Free counseling (9152987821)
- **Vandrevala Foundation**: 24/7 helpline
- **Private therapists**: ₹1,500-5,000/session
- **Hospital psychiatry**: All major hospitals

### Finding Help
- Practo: Mental health category
- Referrals from physicians
- Support groups available
- Online therapy options

---

## Dental Care

### Types
| Type | Cost Range |
|------|------------|
| Cleaning | ₹500-2,000 |
| Filling | ₹500-3,000 |
| Root canal | ₹5,000-15,000 |
| Crown | ₹5,000-20,000 |
| Implant | ₹25,000-75,000 |

### Where
- Clove Dental (chain)
- Apollo White
- Hospital dental departments
- Private clinics

---

## Vaccinations

### Routine
- Available at hospitals and clinics
- Government clinics: Free/subsidized

### Travel
- Yellow fever, typhoid, etc.
- Available at designated centers
- Breach Candy, Kokilaben

### COVID
- Still available
- Government and private centers

---

## Maternity Care

### Delivery Costs

| Type | Range |
|------|-------|
| Normal (good private) | ₹80,000-1,50,000 |
| Normal (premium) | ₹1,50,000-3,00,000 |
| C-section (good private) | ₹1,20,000-2,50,000 |
| C-section (premium) | ₹2,50,000-5,00,000 |

### Top Maternity Hospitals
- Breach Candy
- Lilavati
- Surya Hospital
- Wockhardt

---

## Alternative Medicine

### Available
- Ayurveda: Widespread
- Homeopathy: Common
- Naturopathy: Available
- Yoga therapy: Many centers

### Caution
- Don't replace critical care
- Inform allopathic doctors
- Quality varies widely

---

## Health Tips for Mumbai

### Water
- Never drink tap water
- Bottled or RO filtered only
- Ice in good restaurants usually safe

### Food
- Build tolerance gradually
- Start with cooked foods
- Street food: High-turnover places

### Air
- Moderate to poor AQI
- Mask on bad days
- Air purifier for home (optional)

### Monsoon Health
| Issue | Prevention |
|-------|------------|
| Waterborne illness | Purified water, cooked food |
| Dengue | Mosquito repellent |
| Leptospirosis | Avoid wading in flood water |
| Fungal infections | Keep dry, anti-fungal powder |

---

## Costs Summary

| Service | Approximate Cost |
|---------|------------------|
| GP visit | ₹500-1,000 |
| Specialist visit | ₹1,000-3,000 |
| Blood test (basic) | ₹500-1,500 |
| X-ray | ₹500-1,000 |
| CT scan | ₹3,000-8,000 |
| MRI | ₹6,000-15,000 |
| ER visit (private) | ₹2,000-10,000 |
| Hospital day (room) | ₹5,000-25,000 |
| ICU per day | ₹15,000-50,000 |

---

## Quick Tips

1. **Get health insurance** — Non-negotiable
2. **Save hospital numbers** — Your area's best options
3. **Carry insurance card** — Always
4. **Build doctor relationship** — Regular checkups
5. **Keep medicines stocked** — Basic first aid
6. **Practo app** — For finding doctors
7. **Hydrate** — Mumbai heat + humidity
8. **Regular checkups** — Annual preventive
