# Mumbai Food — Practical Information

## Dietary Considerations

### Vegetarian

Mumbai is **extremely vegetarian-friendly**:
- ~40% of population is vegetarian
- Almost every restaurant has veg section
- Many "pure veg" (no meat cooked) restaurants
- Veg/Non-veg clearly marked on menus
- Green dot = vegetarian, Red dot = non-vegetarian

**Easy vegetarian areas**: Ghatkopar, Borivali, Dadar
**Vegetarian-focused cuisines**: Gujarati, South Indian (Udipi), Jain

### Vegan

Harder than vegetarian but doable:
- Dairy is ubiquitous in Indian cooking (ghee, paneer, curd)
- Specify "no dairy" ("dairy nahi chahiye")
- South Indian dosas often made with rice only (check)
- Most sabzis (vegetables) can be made without cream

**Vegan-friendly options**:
- South Indian: Dosas, idlis, sambar (usually vegan)
- Chaat: Bhel puri, sev puri (ask no curd)
- Chinese: Many options sans dairy
- Specialty cafes: Birdsong, Yoga House (Bandra)

### Jain

Jain dietary laws = no onion, no garlic, no root vegetables, no eating after sunset.

Mumbai caters well to Jains:
- Many "Jain food" options in restaurants
- Ghatkopar and other Gujarati areas specialize
- Hotels usually have Jain options

**Jain-friendly restaurants**: Rajdhani, Swati, any Gujarati thali place

### Halal

Mumbai has large Muslim population:
- Mohammed Ali Road area: All halal
- Many restaurants are halal (ask if unsure)
- Hotels: Usually halal options available
- "Muslim restaurants" always halal

### Gluten-Free

Challenging but possible:
- Rice-based South Indian food (dosa, idli)
- Rice dishes generally
- Many Indian dishes naturally gluten-free
- Bread/roti/naan contain gluten
- Be cautious with sauces (may contain wheat)

---

## Alcohol in Mumbai

### Legal Status
- **Legal age**: 25 years (highest in India)
- **Licensed venues only**: Hotels, bars, wine shops
- **Dry days**: Republic Day, Independence Day, Gandhi Jayanti, election days

### Where to Buy
- **Wine shops**: "MHADA" licensed shops
- **Supermarkets**: Some have attached wine sections
- **Hours**: Usually 10am-10:30pm (varies)

### Where to Drink
- **Hotel bars**: Most reliable
- **Standalone bars**: Abundant in Bandra, Lower Parel, Colaba
- **Restaurants with bar license**: Check for license

### Prices
| Drink | Bar Price | Shop Price |
|-------|-----------|------------|
| Beer (pint) | ₹300-500 | ₹150-250 |
| Whisky (peg) | ₹400-800 | N/A |
| Wine (glass) | ₹600-1,200 | N/A |
| Cocktails | ₹500-1,200 | N/A |

### Best Bar Areas
- **Bandra**: Toit, Woodside Inn, Monkey Bar
- **Lower Parel**: Toit, Social
- **Colaba**: Cafe Mondegar, Busaba
- **BKC**: AER (rooftop)

### Indian Alcohol
- **Kingfisher**: Most common beer
- **Bira**: Craft beer brand
- **Old Monk**: Iconic rum
- **Sula**: Indian wine (decent)

---

## Ramadan in Mumbai

### What Changes
- **Mohammed Ali Road**: Transforms into food festival at Iftar (sunset)
- **Many Muslim areas**: Special foods available
- **No fasting required**: For non-Muslims
- **Restaurants open**: Normal operations continue

### Ramadan Food Highlights
| Food | What It Is |
|------|-----------|
| Haleem | Slow-cooked meat-wheat porridge |
| Nalli Nihari | Bone marrow stew |
| Phirni | Rice pudding |
| Malpua | Sweet pancakes |
| Sheer Kurma | Vermicelli pudding |
| Kebabs | Various, peak season |

### Best Experience
Mohammed Ali Road after sunset during Ramadan is a **must-visit** food experience.

---

## Festival Foods

### Ganesh Chaturthi (August/September)
- **Modak**: Sweet dumplings, Ganesha's favorite
- Steamed or fried versions
- Best: Home-made or sweet shops in Dadar/Girgaum

### Diwali (October/November)
- **Mithai**: Sweets everywhere
- **Dry fruits**: Gift tradition
- Sweet shops go all out

### Holi (March)
- **Gujiya**: Sweet dumplings
- **Thandai**: Spiced milk drink (sometimes with bhang)

### Eid
- **Biryani**: Celebratory dish
- **Seviyan**: Sweet vermicelli
- **Kebabs**: Everywhere

---

## Tipping Culture

### Restaurants
- **Service charge**: Often 5-10% already added
- **If no service charge**: 10-15% appropriate
- **Street food**: No tipping expected
- **Delivery**: ₹20-50 appreciated

### How to Tip
- Can add to card payment
- Cash preferred (goes directly to staff)
- Don't overtip (can cause awkwardness)

---

## Water & Hygiene

### Water Rules
- **Never drink tap water**
- Bottled water everywhere: Bisleri, Kinley, Aquafina
- Check seal is intact
- Restaurant water usually safe (filtered)
- Ice in good restaurants: Usually safe (made from filtered water)

### Food Hygiene
| Safe | Caution | Avoid |
|------|---------|-------|
| Cooked food | Street salads | Tap water |
| Established stalls | Ice in basic places | Uncooked items from street |
| High-turnover places | Cut fruits from street | Empty-looking stalls |

### Stomach Adjustment
1. **Days 1-3**: Stick to cooked food, bottled water
2. **Day 4-7**: Add established street food
3. **Week 2+**: Enjoy freely (usually adapted by then)

**If you get sick**: ORS packets (chemist), bland food, hydrate

---

## Ordering & Etiquette

### Restaurant Ordering
- **"Thali"**: Complete meal with refills
- **"À la carte"**: Individual dishes
- **"Veg/Non-veg"**: Always specified
- **"Portion"**: Usually generous

### Useful Hindi Food Phrases
| Phrase | Meaning |
|--------|---------|
| Kam teekha | Less spicy |
| Bahut teekha | Very spicy |
| Meetha | Sweet |
| Namkeen | Salty/savory |
| Bina pyaz lehsun | Without onion-garlic |
| Kitna hua? | How much (total)? |
| Bill please | Understood universally |

### Eating Etiquette
- **Right hand**: Traditional for eating
- **Sharing**: Common and encouraged
- **Finish plate**: Leaving food can be seen as wasteful
- **Burping**: Not as offensive as in West (sometimes a compliment)

---

## Food Delivery

### Apps
| App | Best For | Notes |
|-----|----------|-------|
| Swiggy | Widest selection | Most restaurants |
| Zomato | Discovery + delivery | Good reviews |
| Dunzo | Anything pickup | Restaurant or grocery |
| Big Basket | Groceries | Fresh produce |
| Blinkit | Quick grocery | 10-minute delivery |

### Delivery Tips
- Addresses can be tricky: Use landmarks
- Cash or online payment
- Track delivery in app
- Tip in app or cash (₹20-50)

---

## Grocery Shopping

### Supermarkets
- **DMart**: Best prices, crowds
- **Big Bazaar**: Variety
- **Nature's Basket**: Premium/imported
- **Foodhall**: Gourmet
- **Hypercity**: General

### For Expats/Foreigners
- **Nature's Basket**: International products
- **Foodhall**: High-end imports
- **Amazon/BigBasket**: Online, good selection

### Local Markets
- **Crawford Market**: Fresh produce, wholesale
- **Linking Road**: Some food items
- **Local mandis**: Neighborhood vegetable markets

---

## Late Night Eating (After Midnight)

| Place | Location | Open Until | What |
|-------|----------|------------|------|
| Bademiya | Colaba | 4am | Kebabs |
| Sardar | Tardeo | 2am | Pav bhaji |
| Amar Juice Centre | Vile Parle | 2am | Pav bhaji |
| Mohammed Ali Rd | Dongri | 3am | Kebabs |
| McDonald's | Multiple | 24/7 | Fast food |
| Shamiana (Taj) | Colaba | 24/7 | Hotel restaurant |
| Local chai stalls | Everywhere | Late | Chai, bread |

---

## Budget Eating Guide

### ₹100/meal
- Vada pav + chai
- Idli/dosa at Udipi
- Street chaat

### ₹200-300/meal
- Local restaurant lunch (thali)
- Pav bhaji with juice
- Frankie + dessert

### ₹500/meal
- Good casual restaurant
- Multiple street food items
- Chain restaurant meal

### ₹1,000+/meal
- Upscale casual
- Hotel coffee shop
- Good dinner

---

## Food Photography

### Allowed
- Most restaurants: Yes
- Street food: Usually yes (ask permission for people)
- Fine dining: Usually yes (be discreet)

### Tips
- Natural light: Best near windows
- Don't hold up service
- Food cools fast: Shoot quick
- Popular spots: Expect similar shots from others
