# Mumbai Cost of Living

## Overview

Mumbai is India's most expensive city. Housing drives most of the cost — other expenses are quite reasonable by global standards.

**Key factors**:
- Housing: 40-60% of budget
- Location dramatically affects costs
- Lifestyle choices create huge variance
- Much cheaper than Western cities despite being "expensive for India"

---

## Housing Costs (Monthly Rent)

### South Mumbai

| Type | Area | Range (₹) | Range ($) |
|------|------|-----------|-----------|
| 1BHK | Colaba | 60,000-1,50,000 | 720-1,800 |
| 1BHK | Fort | 50,000-1,20,000 | 600-1,440 |
| 1BHK | Marine Lines | 50,000-1,00,000 | 600-1,200 |
| 2BHK | South Mumbai avg | 80,000-2,00,000 | 960-2,400 |
| 3BHK | Malabar Hill | 1,50,000-5,00,000 | 1,800-6,000 |

### Western Suburbs

| Type | Area | Range (₹) | Range ($) |
|------|------|-----------|-----------|
| 1BHK | Bandra West | 50,000-1,20,000 | 600-1,440 |
| 1BHK | Khar | 45,000-90,000 | 540-1,080 |
| 1BHK | Andheri West | 35,000-70,000 | 420-840 |
| 1BHK | Goregaon | 28,000-55,000 | 336-660 |
| 1BHK | Malad | 25,000-45,000 | 300-540 |
| 2BHK | Bandra West | 80,000-1,80,000 | 960-2,160 |

### Central Suburbs

| Type | Area | Range (₹) | Range ($) |
|------|------|-----------|-----------|
| 1BHK | Powai | 40,000-80,000 | 480-960 |
| 1BHK | Ghatkopar | 28,000-55,000 | 336-660 |
| 1BHK | Chembur | 25,000-50,000 | 300-600 |

### Extended Mumbai

| Type | Area | Range (₹) | Range ($) |
|------|------|-----------|-----------|
| 1BHK | Navi Mumbai (Vashi) | 18,000-35,000 | 216-420 |
| 1BHK | Thane | 20,000-40,000 | 240-480 |
| 1BHK | Navi Mumbai (Kharghar) | 15,000-28,000 | 180-336 |

### Additional Housing Costs

| Item | Amount | Notes |
|------|--------|-------|
| Security deposit | 2-6 months rent | Typically 3 months |
| Brokerage | 1-2 months rent | One-time |
| Maintenance | ₹3,000-15,000/month | Building dependent |
| Society charges | ₹10,000-50,000 | One-time deposit |

---

## Utilities

| Utility | Monthly Cost | Notes |
|---------|--------------|-------|
| Electricity | ₹1,500-5,000 | AC usage drives this |
| Water | ₹200-500 | Included in some societies |
| Gas (cooking) | ₹500-1,000 | Cylinder or piped |
| Internet | ₹500-1,500 | 100+ Mbps fiber |
| Mobile | ₹300-800 | Prepaid plans |
| Netflix/Prime | ₹200-500 | Indian pricing |
| Cable/DTH | ₹300-500 | If needed |
| **Total utilities** | ₹3,000-9,000 | Without luxury items |

---

## Food & Dining

### Groceries (Monthly)

| Household | Amount (₹) | Amount ($) |
|-----------|------------|------------|
| Single person | 6,000-12,000 | 72-144 |
| Couple | 10,000-18,000 | 120-216 |
| Family of 4 | 15,000-30,000 | 180-360 |

### Eating Out

| Type | Per Person (₹) | Per Person ($) |
|------|----------------|----------------|
| Street food | 50-150 | 0.60-1.80 |
| Local restaurant | 150-300 | 1.80-3.60 |
| Cafe | 300-600 | 3.60-7.20 |
| Casual dining | 500-1,000 | 6-12 |
| Mid-range restaurant | 1,000-2,000 | 12-24 |
| Fine dining | 2,500-5,000+ | 30-60+ |
| Drinks (bar) | 500-1,500 | 6-18 |
| Sunday brunch | 2,500-5,000 | 30-60 |

### Delivery

| Service | Typical Order |
|---------|---------------|
| Food delivery (per order) | ₹200-500 |
| Grocery delivery | Free over ₹500 usually |

---

## Transport

### Daily Commuting

| Mode | Monthly Cost (₹) | Notes |
|------|------------------|-------|
| Local train pass (Second) | 200-400 | Very cheap |
| Local train pass (First) | 400-800 | Less crowded |
| Metro monthly | 1,000-2,000 | If using daily |
| Auto/Uber daily | 5,000-15,000 | Location dependent |
| Mix (train + auto) | 2,000-5,000 | Most common |

### Car Ownership

| Item | Monthly Cost (₹) | Notes |
|------|------------------|-------|
| EMI (if financed) | 15,000-40,000 | Depends on car |
| Fuel | 5,000-15,000 | Usage dependent |
| Parking (monthly) | 3,000-10,000 | Area dependent |
| Insurance | 800-2,000 | Amortized |
| Maintenance | 2,000-4,000 | Averaged |
| **Total ownership** | 25,000-70,000 | High for Mumbai |

---

## Healthcare

### Insurance

| Type | Annual Premium | Coverage |
|------|----------------|----------|
| Basic health | ₹10,000-20,000 | ₹5 lakh |
| Comprehensive | ₹25,000-50,000 | ₹10-25 lakh |
| Family floater | ₹30,000-80,000 | ₹15-50 lakh |
| International coverage | ₹1,00,000+ | Global |

### Out of Pocket

| Service | Cost |
|---------|------|
| GP consultation | ₹500-1,500 |
| Specialist consultation | ₹1,000-3,000 |
| Basic blood tests | ₹500-2,000 |
| ER visit (private hospital) | ₹5,000-15,000 |
| Dental cleaning | ₹1,000-3,000 |

---

## Education

### Schools (Annual Fees)

| Type | Fees (₹) | Fees ($) |
|------|----------|----------|
| Local CBSE/ICSE | 50,000-2,00,000 | 600-2,400 |
| Good CBSE/ICSE | 1,50,000-4,00,000 | 1,800-4,800 |
| IB Curriculum | 5,00,000-15,00,000 | 6,000-18,000 |
| International schools | 10,00,000-25,00,000 | 12,000-30,000 |

### Higher Education (Annual)

| Type | Fees (₹) |
|------|----------|
| Local college | 20,000-1,00,000 |
| Good private college | 2,00,000-10,00,000 |
| MBA (IIM) | 20,00,000+ |
| MBA (private) | 10,00,000-25,00,000 |

---

## Domestic Help

| Service | Monthly Cost (₹) | Notes |
|---------|------------------|-------|
| Part-time maid | 3,000-8,000 | 1-2 hours daily |
| Full-time maid | 12,000-25,000 | 8 hours |
| Cook (part-time) | 5,000-12,000 | Cooking only |
| Driver | 15,000-25,000 | Full-time |
| Nanny | 15,000-30,000 | Full-time |
| Watchman (society) | Included | In maintenance |

---

## Entertainment & Lifestyle

| Activity | Cost |
|----------|------|
| Movie ticket (multiplex) | ₹200-500 |
| Movie ticket (PVR Luxe) | ₹600-1,500 |
| Gym (monthly) | ₹2,000-8,000 |
| Premium gym (Cult, F45) | ₹5,000-12,000 |
| Yoga class | ₹3,000-8,000 |
| Weekend pub night | ₹2,000-5,000 |
| Concert/event | ₹1,000-10,000+ |
| Cricket match (IPL) | ₹1,000-25,000 |

---

## Monthly Budget Examples

### Young Professional (Single, Bandra/Andheri)

| Category | Amount (₹) |
|----------|------------|
| Rent (1BHK shared or studio) | 30,000-40,000 |
| Utilities | 3,000 |
| Groceries | 8,000 |
| Eating out (10x/month) | 8,000 |
| Transport | 5,000 |
| Entertainment | 5,000 |
| Misc | 5,000 |
| **Total** | **64,000-74,000** |

### Professional (Single, Comfortable)

| Category | Amount (₹) |
|----------|------------|
| Rent (1BHK Bandra) | 55,000 |
| Utilities | 4,000 |
| Groceries | 10,000 |
| Eating out | 15,000 |
| Transport (Uber mix) | 8,000 |
| Entertainment | 8,000 |
| Gym | 4,000 |
| Misc | 6,000 |
| **Total** | **1,10,000** |

### Couple (No Kids, Comfortable)

| Category | Amount (₹) |
|----------|------------|
| Rent (2BHK Bandra/Powai) | 70,000 |
| Utilities | 5,000 |
| Groceries | 15,000 |
| Eating out | 20,000 |
| Transport | 12,000 |
| Entertainment | 12,000 |
| Help (part-time) | 5,000 |
| Misc | 10,000 |
| **Total** | **1,49,000** |

### Family with Kids (Comfortable)

| Category | Amount (₹) |
|----------|------------|
| Rent (3BHK Powai) | 90,000 |
| Utilities | 8,000 |
| Groceries | 25,000 |
| Eating out | 15,000 |
| Transport (car or heavy Uber) | 25,000 |
| School fees (2 kids, amortized) | 40,000 |
| Help (maid + cook) | 18,000 |
| Healthcare | 5,000 |
| Entertainment | 10,000 |
| Misc | 15,000 |
| **Total** | **2,51,000** |

---

## Saving Money Tips

### Housing
- Consider slightly further areas (huge savings)
- Negotiate deposit down
- Share accommodation initially
- NoBroker to avoid brokerage

### Food
- Cook more often
- Local restaurants over trendy cafes
- Street food (safe and cheap)
- Buy groceries from markets, not gourmet stores

### Transport
- Use trains for commute
- Walk for short distances
- Share rides (Uber Pool)
- Work from home when possible

### Entertainment
- Free events (cultural festivals, beach walks)
- Happy hours for drinks
- Matinee shows
- Parks and beaches over paid venues

---

## Comparison with Other Cities

| Item | Mumbai | NYC | London | Singapore |
|------|--------|-----|--------|-----------|
| 1BR rent (good area) | $720-1,200 | $2,500-4,000 | £1,800-2,500 | S$2,500-3,500 |
| Meal (casual) | $5-12 | $15-25 | £12-20 | S$10-20 |
| Coffee | $2-4 | $5-7 | £3-4 | S$5-8 |
| Local transport | $0.20-0.50 | $2.90 | £2.50+ | S$1-2 |
| Internet | $10-15 | $50-80 | £30-40 | S$30-50 |

**Conclusion**: Mumbai is expensive for India but very affordable by global standards.
