# Mumbai Business Setup Guide

## Business Environment

Mumbai is India's **commercial capital**:
- Stock exchanges (BSE, NSE)
- Major banks and financial institutions
- Corporate headquarters
- Trade and shipping hub

---

## Business Entity Types

| Type | Best For | Liability | FDI Allowed |
|------|----------|-----------|-------------|
| Private Limited | Startups, growth companies | Limited | Yes |
| LLP | Professional services | Limited | Restricted |
| Sole Proprietorship | Freelancers | Unlimited | No |
| Partnership | Small businesses | Unlimited | No |
| Public Limited | Large companies | Limited | Yes |
| Branch Office | Foreign company presence | Parent | Yes (approval) |
| Subsidiary | Foreign company (full ops) | Limited | Yes |

### Private Limited Company (Most Common)
- Minimum 2 directors, 2 shareholders
- ₹1 lakh minimum capital (nominal)
- Limited liability
- Easy to raise funding
- Setup time: 15-30 days
- Cost: ₹15,000-50,000 (including compliance)

### LLP (Limited Liability Partnership)
- For professional services
- Less compliance than Pvt Ltd
- Cannot raise VC funding easily
- Good for consulting, services

---

## Registration Process

### Private Limited Company

**Step 1: DSC & DIN**
- Digital Signature Certificate (DSC)
- Director Identification Number (DIN)
- Time: 3-5 days
- Cost: ₹2,000-3,000

**Step 2: Name Reservation**
- Apply on MCA portal
- 2 name choices
- Valid for 20 days
- Cost: ₹1,000

**Step 3: Incorporation**
- SPICe+ form on MCA
- MOA, AOA filing
- Time: 7-15 days
- Cost: ₹3,000-5,000 (government fees)

**Step 4: Post-Incorporation**
- PAN and TAN (automatic with SPICe+)
- Bank account
- GST registration
- Professional Tax registration

### Using Professionals
Most companies use CAs/CS for registration:
- Cost: ₹15,000-40,000 all-inclusive
- Much faster and error-free
- Recommended for foreigners

---

## Business Locations

### Premium Office Areas

| Area | Type | Cost (per sq ft/month) |
|------|------|------------------------|
| BKC | Corporate | ₹250-400 |
| Nariman Point | Traditional | ₹200-350 |
| Lower Parel | Modern | ₹180-300 |
| Worli | Premium | ₹200-350 |

### Mid-Range Areas

| Area | Type | Cost (per sq ft/month) |
|------|------|------------------------|
| Andheri East | IT/Commercial | ₹80-150 |
| Powai | Tech hub | ₹120-200 |
| Goregaon (Mindspace) | IT park | ₹80-140 |
| Malad | Commercial | ₹60-100 |

### Budget/Startup Areas

| Area | Type | Cost (per sq ft/month) |
|------|------|------------------------|
| Navi Mumbai | SEZ available | ₹40-80 |
| Thane | Growing hub | ₹50-90 |

---

## Compliance Requirements

### Regular Compliance

| Compliance | Frequency | Deadline |
|------------|-----------|----------|
| GST returns | Monthly/Quarterly | 11th-20th |
| TDS returns | Quarterly | 31st of following month |
| Annual returns (MCA) | Annual | Within 60 days of AGM |
| Financial statements | Annual | Within 30 days of AGM |
| AGM | Annual | Within 6 months of FY end |
| Income tax | Annual | 31st October |
| Professional tax | Monthly | 20th |

### Key Registrations

| Registration | Required For | Time |
|--------------|--------------|------|
| GST | Turnover >₹40L (goods) / >₹20L (services) | 7-10 days |
| Professional Tax | All employers | 3-5 days |
| EPFO | >20 employees | 7-10 days |
| ESIC | >10 employees (salary <₹21K) | 7-10 days |
| Shops & Establishment | All businesses | 7-15 days |
| FSSAI | Food business | 30-60 days |
| Import-Export Code | Import/export | 5-7 days |

---

## Banking for Business

### Opening Business Account
**Requirements:**
- Certificate of Incorporation
- MOA, AOA
- PAN card
- GST certificate
- Board resolution
- Director KYC

**Recommended Banks:**
- HDFC Bank (good digital, service)
- ICICI Bank (strong corporate)
- Kotak (startup friendly)
- RBL (startup focus)
- Yes Bank (corporate)

### Business Banking Features
- Current account (no interest)
- Cash management
- Trade finance
- RTGS/NEFT (instant transfers)
- International banking

---

## Hiring Employees

### Employment Laws
- **Shops & Establishment Act**: Basic labor law
- **Payment of Wages Act**: Timely salary payment
- **PF & ESIC**: Mandatory for eligible employers
- **Maternity Benefit**: 26 weeks paid leave
- **Gratuity**: After 5 years of service

### Typical Costs Per Employee

| Component | Amount |
|-----------|--------|
| Base salary | As agreed |
| EPF (employer) | 12% of basic |
| ESI (employer) | 3.25% (if applicable) |
| Professional tax | ₹200/month |
| Insurance | ₹500-2,000/month |
| **Total employer cost** | ~15-20% above salary |

### Notice Periods
- Typically 1-3 months
- Negotiable in offer letter
- Buyout possible

---

## Taxation

### Corporate Tax Rates (FY 2025-26)

| Company Type | Rate |
|--------------|------|
| Turnover < ₹400 Cr | 25% |
| New manufacturing companies | 15% |
| Others | 22% (concessional) or 30% |
| + Surcharge and cess | Varies |

### GST
| Category | Rate |
|----------|------|
| Most services | 18% |
| Software/IT | 18% |
| Basic goods | 5% |
| Standard goods | 12-18% |
| Luxury | 28% |

### Input Tax Credit
- GST paid on purchases can be claimed
- Reduces effective tax burden
- Proper invoicing essential

---

## Foreign Investment

### FDI Routes

| Route | Meaning | Sectors |
|-------|---------|---------|
| Automatic | No approval needed | Most sectors |
| Approval | Government approval | Defense, media, etc. |

### Key Sectors (Automatic Route)
- IT/Software: 100% FDI
- E-commerce (marketplace): 100% FDI
- Manufacturing: 100% FDI
- Fintech: Up to 100% (varies by activity)

### Setting Up as Foreign Company

**Options:**
1. **Subsidiary**: Indian company, foreign parent owns shares
2. **Branch Office**: Extension of foreign company
3. **Liaison Office**: Non-commercial activities only
4. **Project Office**: Specific project execution

**Most common**: Wholly-owned subsidiary

---

## Professional Services

### Finding Professionals

| Service | Where to Find |
|---------|---------------|
| CA (Accounting/Tax) | ICAI directory, referrals |
| CS (Company Secretary) | ICSI directory |
| Lawyer | Bar Council, referrals |
| HR/Payroll | Platforms (Greythr, Zoho) |

### Typical Costs

| Service | Monthly Cost |
|---------|--------------|
| CA (small company) | ₹10,000-25,000 |
| CA (growing company) | ₹25,000-50,000 |
| CS (compliance) | ₹5,000-15,000 |
| Payroll service | ₹100-200/employee |

---

## Special Economic Zones (SEZ)

### Benefits
- Tax holidays (15-year benefits)
- Duty-free imports
- Single-window clearance
- Cheaper space

### Mumbai SEZs
- SEEPZ (Andheri)
- Navi Mumbai SEZ
- Various IT parks with SEZ status

---

## Real Estate for Business

### Leasing Office Space

**Typical Terms:**
- Lease period: 3-9 years
- Lock-in: 3 years usually
- Security deposit: 6-12 months rent
- Rent escalation: 5-15% every 3 years
- CAM (maintenance): ₹15-40/sq ft additional

### Co-working Alternative
- No lock-in
- Flexible scaling
- Higher per-seat cost but no commitment
- Good for startups

---

## Key Contacts

| Organization | Purpose |
|--------------|---------|
| Maharashtra Industrial Development Corporation (MIDC) | Industrial plots |
| Small Industries Development Bank of India (SIDBI) | SME loans |
| Mumbai Chamber of Commerce | Business networking |
| Invest India | Foreign investment facilitation |
| StartupIndia | Startup registration, benefits |
