---
name: Mumbai
slug: mumbai
version: 1.0.0
homepage: https://clawic.com/skills/mumbai
description: Navigate Mumbai as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, local trains, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🏙️","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Mumbai for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| South Mumbai (Colaba, Fort, Marine Drive) | `neighborhoods-south.md` |
| Bandra & Western Suburbs | `neighborhoods-bandra.md` |
| Powai & Central Suburbs | `neighborhoods-central.md` |
| Navi Mumbai & Thane | `neighborhoods-extended.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Street food & local classics | `food-street.md` |
| Regional Indian cuisines | `food-regional.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary & practical tips | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (local trains, auto, metro) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & tips | `safety.md` |
| Weather & monsoon survival | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & regulations | `business.md` |
| Visas (employment, OCI, business) | `visas.md` |
| Startups & funding ecosystem | `startup.md` |
| Bollywood & media industry | `entertainment.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & hospitals | `healthcare.md` |
| Schools & education | `education.md` |
| Expat & local lifestyle | `lifestyle.md` |
| Driving & traffic reality | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur, NRI returning
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Maximum City Reality
Mumbai is India's financial capital and most populous city:
- 20+ million people in metro area
- Extreme density in island city (South Mumbai)
- Housing is the primary expense and challenge
- "Jugaad" (creative problem-solving) is essential
See `resident.md` for settling guidance.

### 3. Train-Centric Transport
Unlike car-centric cities, Mumbai runs on local trains:
- **Western Line**: Churchgate to Dahanu (suburbs)
- **Central Line**: CST to Kasara/Karjat
- **Harbour Line**: CST to Panvel (Navi Mumbai)
- 7.5 million daily passengers — world's most crowded
- Peak hours (8-11am, 5-9pm) are intense
See `transport.md` for survival guide.

### 4. Monsoon Reality
- **Monsoon (June-September)**: Heavy rainfall, flooding common
- **October-February**: Pleasant, best time to visit
- **March-May**: Hot and humid, pre-monsoon
- Monsoon affects everything: transport, housing (waterlogging), daily life
See `climate.md` for monthly breakdown and monsoon survival.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BHK rent (Bandra) | ₹40,000-80,000/month (~$475-950) |
| 1BHK rent (South Mumbai) | ₹50,000-1,50,000/month (~$600-1,800) |
| Senior SWE salary | ₹40-80 LPA (~$48K-96K/year) |
| Local train monthly pass | ₹500-1,500 (~$6-18) |
| Street food meal | ₹50-150 (~$0.60-1.80) |
| Restaurant meal (mid-range) | ₹500-1,500/person (~$6-18) |
| International school fees | ₹5-25 LPA (~$6K-30K/year) |

### 6. Housing Reality
Mumbai has India's most expensive real estate:
- **South Mumbai**: Premium, colonial buildings, sea views, astronomical prices
- **Bandra-Khar-Santacruz**: Hip, expat-friendly, Bollywood crowd
- **Powai**: Tech hub, modern apartments, lake views
- **Navi Mumbai**: Affordable, planned city, longer commute
- **Deposit**: 3-6 months rent (negotiable)
- **Brokerage**: 1-2 months rent
See `neighborhoods-*.md` for detailed area guides.

### 7. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Bandra, Lower Parel, Andheri |
| Families | Powai, Hiranandani, Thane |
| Heritage/culture lovers | South Mumbai, Fort, Colaba |
| Tech workers | Powai, BKC, Andheri East |
| Budget-conscious | Navi Mumbai, Thane, Malad |
| Bollywood/media | Bandra, Juhu, Versova |
| Sea views | Marine Drive, Worli, Bandra Bandstand |

### 8. Business Environment
- **BKC (Bandra Kurla Complex)**: Financial district, corporate HQs
- **Lower Parel**: Old mills converted to offices, media companies
- **Andheri-Powai corridor**: Tech parks, IT companies
- **Nariman Point**: Traditional business district (declining)
- SEZ benefits available in certain zones
See `business.md` and `startup.md` for setup guidance.

## Mumbai-Specific Traps

- **Monsoon underestimation** — July flooding can strand you for hours. Check weather before traveling.
- **Peak hour trains** — 8-10am and 6-8pm are brutal. Avoid or be prepared to stand crushed.
- **Housing deposits** — Landlords ask for 6+ months. Negotiate to 3 months.
- **Broker fees** — Standard is 1 month rent. Some charge 2 months illegally.
- **Auto/taxi refusals** — Drivers often refuse destinations. Use Uber/Ola instead.
- **Traffic assumptions** — A 10km journey can take 2 hours. Always add buffer time.
- **Water quality** — Don't drink tap water. Filtered/bottled only.
- **Power cuts** — Still happen in some areas. Check backup power in apartments.
- **Festival traffic** — Ganesh Chaturthi, Diwali create massive congestion.
- **Rent vs buy** — Buying is extremely expensive. Most people rent for years.

## Cultural Context

Mumbai is cosmopolitan but has local customs:
- **Language**: Hindi and Marathi are primary. English widely spoken in business.
- **Festivals**: Ganesh Chaturthi (Sep) is THE Mumbai festival.
- **Dress code**: Liberal by Indian standards but modest in religious sites.
- **Tipping**: 10% in restaurants, small tips to service staff appreciated.
- **Bargaining**: Expected in markets, not in malls/fixed-price shops.
- **Personal space**: Different norms in crowded areas — patience required.
See `culture.md` for detailed guidance.

## Visa Information

For foreigners:
- **e-Visa**: Available for tourism (30/90/180 days)
- **Employment Visa**: Requires job offer, company sponsorship
- **Business Visa**: For business meetings, conferences
- **OCI (Overseas Citizen of India)**: For people of Indian origin — lifetime validity

For NRIs returning:
- No visa needed but tax residency rules apply
- Bank account options (NRE/NRO) important
See `visas.md` for detailed requirements.

## Related Skills
Install with `clawhub install <slug>` if user confirms:

- `dubai` — Fellow financial hub, many Mumbai expats there
- `travel` — General travel planning and tips
- `austin` — Tech hub comparison for relocation decisions

## Feedback

- If useful: `clawhub star mumbai`
- Stay updated: `clawhub sync`
