# Init Guide

## Overview

`workplace init` sets up a `.workplace/` directory in a project folder. The flow differs for empty vs existing projects.

## Empty Folder Init

### Information to Gather

Ask the user (don't overwhelm — prioritize):

1. **Project name** — what to call this workplace
2. **Description** — brief project summary
3. **Language/framework** — primary tech stack
4. **Agent roles** — what kind of agents are needed (suggest based on project type)
5. **Deploy environments** — dev/main/pre or custom
6. **Linked workplaces** — related projects (optional)

### Steps

```bash
# 1. Create the directory if needed
mkdir -p /path/to/project

# 2. Initialize git
cd /path/to/project && git init

# 3. Run init script
scripts/init_workplace.sh /path/to/project --name "my-app" --desc "Description"

# 4. Create custom agents based on user input
# Write .md files to .workplace/agents/

# 5. Update config.json with language/framework info
```

### Agent Suggestions by Project Type

| Project Type | Suggested Agents |
|-------------|------------------|
| Web app (React/Vue/Next) | coder, reviewer, designer, tester |
| API/Backend | coder, reviewer, tester, devops |
| Library/Package | coder, reviewer, docs-writer |
| Mobile app | coder, reviewer, tester, designer |
| Data/ML | coder, data-engineer, reviewer |
| Monorepo | coder, reviewer, devops, coordinator |
| Static site | coder, content-writer, designer |

These are suggestions — always confirm with the user and support fully custom roles.

## Existing Project Init

### Steps

1. **Check for `.git`**
   ```bash
   scripts/scan_workplaces.sh /path/to/project --max-depth 1
   ```

2. **Run init script**
   ```bash
   scripts/init_workplace.sh /path/to/project
   ```

3. **Scan and analyze**
   - Read `structure.json` (generated by init script)
   - Find and read key `.md` files:
     ```bash
     find /path/to/project -name "*.md" -maxdepth 3 \
       -not -path "*/node_modules/*" \
       -not -path "*/vendor/*" \
       -not -path "*/.workplace/*"
     ```
   - Look for: README.md, CONTRIBUTING.md, package.json, Cargo.toml, go.mod, pyproject.toml, etc.

4. **Analyze project type**
   - Detect language from file extensions and config files
   - Detect framework from dependencies
   - Identify monorepo patterns (workspaces, lerna, nx)
   - Check for CI/CD configs (.github/workflows, Jenkinsfile, etc.)

5. **Suggest agents**
   - Based on project type (see table above)
   - Based on existing contribution patterns
   - Present suggestions to user for confirmation

6. **Create agents**
   - Write `.md` files for confirmed agents
   - Customize instructions based on project analysis
   - Include project-specific context (tech stack, patterns, conventions)

7. **Update deploy docs**
   - Pre-fill `deploy/dev.md` from README setup instructions if available
   - Set language/framework in config.json

8. **Register and set current**
   - Already handled by `init_workplace.sh`

## Post-Init

After initialization:

1. Suggest running `workplace kernel start` to begin structure monitoring
2. Remind user to:
   - Customize agent definitions in `.workplace/agents/`
   - Fill in deploy docs in `.workplace/deploy/`
   - Add workplace-specific skills to `.workplace/skills/`
   - Consider adding `.workplace/memory/` to `.gitignore`

## Re-Init (Related Workplaces)

When a user runs init on a folder that has a parent or linked workplace:

1. Detect parent `.workplace/` in ancestor directories
2. Auto-set `parent` in `config.json`
3. Add the new workplace's UUID to parent's `linked[]`
4. Rebuild `full-tree.md` for both workplaces
