---
name: multi-skill-automation-suite
description: Comprehensive automation suite combining multiple OpenClaw skills for security, development, content processing, and utilities. Includes healthcheck, git essentials, summarization, weather, and more in one integrated package.
metadata:
  {
    "openclaw":
      {
        "requires": { "bins": ["git", "curl"] },
        "install": []
      }
  }
---

# Multi-Skill Automation Suite

Comprehensive automation suite that combines multiple essential OpenClaw skills into one integrated package for maximum productivity.

## Included Skills

### 🔒 Security & Monitoring
- **Healthcheck**: Host security hardening, risk assessment, firewall/SSH configuration
- **Proactive Monitoring**: Continuous system health monitoring and alerting

### 🚀 Development & Collaboration  
- **Git Essentials**: Complete version control workflow with branching and collaboration tools
- **Code Management**: Repository status checking, commit management, and push automation

### 📝 Content Processing
- **Summarize**: Multi-format content summarization (web, PDF, images, audio, YouTube)
- **Humanize AI Text**: AI text humanization to bypass detection systems
- **Content Optimization**: Make AI-generated content sound natural and undetectable

### 🛠️ Utilities
- **Weather**: Current weather and forecasts without API keys
- **Skill Discovery**: Find and install new agent skills automatically
- **Browser Automation**: Headless browser control for web interactions

## Features

✅ **All-in-One**: Single installation provides multiple powerful capabilities  
✅ **Integrated Workflow**: Skills work together seamlessly for complex automation  
✅ **Easy Setup**: No complex configuration required  
✅ **Regular Updates**: All included skills stay current with latest versions  
✅ **Resource Efficient**: Optimized to minimize system resource usage  

## Usage

Install the suite and access all included capabilities immediately:

```bash
clawhub install multi-skill-automation-suite
```

Each skill can be used independently or combined for powerful automation workflows.

## Requirements

- OpenClaw v1.0+
- Git (for Git Essentials)
- curl (for various API interactions)
- Standard system utilities

## Integration

This suite integrates perfectly with other OpenClaw skills and can be extended with additional capabilities as needed.