# 🧠 AI协作操作系统

**一站式集成：统一记忆系统 + 信息信号识别 + 工作流资产沉淀 + 个人目标追踪**

---

## 🚀 快速开始

```bash
# 解压
unzip ai-collaboration-complete.zip

# 进入目录
cd ai-collaboration-complete

# 安装
npm install

# 运行演示
node demo.js
```

---

## 📦 包含系统

| 系统 | 功能 | 核心能力 |
|------|------|----------|
| **统一记忆系统** | 五层记忆管理 | L0闪存→L1工作→L2经验→L3知识→L4智慧 |
| **信息信号识别** | 信号识别、模式发现 | 信息价值分层、世界观构建、时间衰减 |
| **工作流资产沉淀** | 隐性知识显性化 | 能力基因识别、方法论构建 |
| **个人目标追踪** | 动机解析、AI镜像 | 目标网络、未来预测 |

---

## 🎯 演示程序

| 文件 | 说明 |
|------|------|
| `demo.js` | 完整功能演示 |
| `duty-demo.js` | 值班机制演示 |
| `time-decay-demo.js` | 时间衰减演示 |
| `examples/holiday-duty.js` | 场景示例：节假日值班热点监测 |

---

## 📝 场景示例

`examples/holiday-duty.js` 展示如何使用本系统实现节假日值班热点监测：

- ✅ 可监测任何类型热点（政策、社会、产业、舆情等）
- ✅ 自动评估关注等级（S/A/B/C）
- ✅ 时间衰减机制（一周以上自动降级）
- ✅ 自动生成日报
- ✅ 使用原有系统所有功能

```bash
node examples/holiday-duty.js
```

---

## 📁 目录结构

```
ai-collaboration-complete/
├── install.sh              # 一键安装
├── README.md               # 本文件
├── package.json            # 项目配置
│
├── scripts/                # TypeScript源代码
│   ├── index.ts            # 主入口
│   ├── core/memory.ts      # 统一记忆系统
│   └── systems/            # 子系统
│
├── dist/                   # 编译输出
│
├── examples/               # 场景示例
│   └── holiday-duty.js     # 节假日值班示例
│
├── demo.js                 # 完整演示
├── duty-demo.js            # 值班演示
├── time-decay-demo.js      # 时间衰减演示
│
├── docs/                   # 文档
│   └── AI协作操作系统_完整使用说明书.md
│
└── memory/                 # 记忆存储
```

---

## 📖 文档

- `docs/AI协作操作系统_完整使用说明书.md` - 完整使用说明（65KB）

---

## ✅ 验证安装

```bash
node demo.js
```

看到 `✅ 演示完成！` 表示安装成功。

---

**一行代码，开启AI协作之旅！**
