---
name: genesis-launch
description: Launch tokens on Solana using Metaplex Genesis protocol
metadata:
  openclaw:
    emoji: "\U0001F680"
    requires:
      config:
        - "plugins.entries.genesis.enabled"
---

# Metaplex Genesis Token Launch

You can help users launch tokens on Solana using the Metaplex Genesis protocol. Genesis enables
fair, transparent token launches with built-in liquidity pool graduation.

## What is Genesis?

Genesis is a token launch protocol on Solana by Metaplex. It supports:

- **LaunchPool**: Fair token distribution where users deposit SOL during a time window, then
  claim tokens proportionally based on their share of total deposits.
- **Unlocked Buckets**: Direct token allocation for team, treasury, or airdrops.
- **Raydium CPMM Graduation**: Automatically creates a Raydium liquidity pool with raised SOL
  and allocated tokens after the launch concludes.

## Launch Lifecycle

1. **Create** the launch (`genesis_create_launch`) - sets up the token and Genesis account
2. **Configure buckets** - add LaunchPool, Unlocked, and/or Raydium buckets
3. **Finalize** (`genesis_finalize_launch`) - locks configuration, launch goes live
4. Users deposit SOL during the deposit period
5. After deposit period, SOL flows to Raydium and a liquidity pool is created
6. Users claim their tokens during the claim period

## Recommended Flow

When a user wants to launch a token, gather this information:

1. **Token details**: name, symbol, description, and image file path
2. **Total supply**: how many tokens (default: 1 billion)
3. **Allocation split**: what percentage goes to launchpool vs liquidity vs team
   - Example: 60% launchpool / 20% Raydium liquidity / 20% team
4. **Timing**: when deposits open, how long they last, when claims start

## Common Configuration: LaunchPool + Raydium + Team

This is the most common setup. Example with 60/20/20 split:

    Step 1: genesis_create_launch
      - name, symbol, description, imagePath
      - totalSupply: 1000000000

    Step 2: genesis_add_raydium_pool (add this FIRST so you know the bucket index)
      - tokenAllocationPercent: 20
      - bucketIndex: 0

    Step 3: genesis_add_launchpool
      - tokenAllocationPercent: 60
      - depositDurationHours: 72 (3 days)
      - claimDurationHours: 168 (7 days)
      - sendQuoteTokenToRaydiumBucketIndex: 0
      - bucketIndex: 0

    Step 4: genesis_add_unlocked
      - tokenAllocationPercent: 20
      - bucketIndex: 0

    Step 5: genesis_finalize_launch
      - raydiumBucketIndexes: [0]
      - launchpoolBucketIndexes: [0]
      - unlockedBucketIndexes: [0]

## Important Notes

- Token allocations across all buckets **must sum to exactly 100%**
- Add the Raydium bucket **before** the LaunchPool so you can reference its bucket index in
  the launchpool's `sendQuoteTokenToRaydiumBucketIndex`
- The Raydium pool creation costs 0.15 SOL
- Metadata (image + JSON) is uploaded to Arweave via Irys, paid from the wallet's SOL
- Use `genesis_launch_status` to check a launch's current state at any time

## Wallet Setup

The plugin needs a Solana keypair. Users can configure it via:
- Plugin config: `keypairPath` pointing to a JSON keypair file
- Environment variable: `SOLANA_KEYPAIR_PATH`
- Default: `~/.config/solana/id.json`

The wallet must have enough SOL for transaction fees, Irys uploads, and the Raydium pool creation fee.
