# 🎬 Movie Butler - 观影小管家

杜老师的专属观影助手 - 媒体库管理 + 电影查询 + 个性化推荐 + 每周推荐

## ✅ 已实现功能

### 1. 🌐 电影查询（全网 + 服务器）✅
- **TMDB 全网查询** - 简介、评分、演员、导演、类型、海报
- **Emby 服务器查询** - 检查是否有该片、画质信息（需 API Key）
- **智能下载建议** - 服务器没有时，提供下载提示
- **一键对比** - 同时显示全网信息和服务器状态

### 2. 📺 Emby 媒体库管理 ⚠️
- 查询服务器上的电影/剧集
- 获取媒体库统计
- 搜索特定影片
- 查看最近添加/最近播放
- **需要配置 Emby API Key**

### 3. 观影记录与偏好 ✅
- 记录看过的电影和感受
- 记录评分
- 分析观影偏好

### 4. 🎯 每周一部电影（NEW!）✅
- 自动生成每周推荐
- 智能分析您的喜好
- 结合 Emby 服务器内容
- 给出详细推荐理由
- 记录每周观影计划

### 5. 背景感知推荐 ✅
- 根据心情推荐（累→轻松，开心→刺激）
- 根据工作状态推荐（忙→犒劳，闲→深度）
- 根据最近关注推荐
- 周末/工作日不同策略

## 🔑 配置说明

### TMDB（已配置）✅
```
TMDB_API_KEY=bd1ba3aa647fbaa7b35e93db5164a53f
```

### Emby（需要补充 API Key）⚠️
```
EMBY_URL=http://192.168.0.151:8096
EMBY_USERNAME=喜悦影音
EMBY_PASSWORD=
EMBY_API_KEY=  ← 需要生成
```

## 📝 生成 Emby API Key 步骤

1. 打开 Emby Web 界面：http://192.168.0.151:8096
2. 登录管理员账号
3. 进入 **控制台** → **高级** → **API 密钥**
4. 点击 **添加**，输入名称（如：MovieButler）
5. 复制生成的 API Key
6. 添加到 `.env` 文件：`EMBY_API_KEY=xxx`

## 💬 使用示例

### 🌐 电影查询（全网 + 服务器）
```
查询《肖申克的救赎》
《星际穿越》的详细信息
```

**输出示例：**
```
🎬 《星际穿越》(2014)

⭐ TMDB 评分：8.5/10 (39009 人评分)
🎭 类型：冒险、剧情、科幻
🎬 导演：克里斯托弗·诺兰
🌟 主演：马修·麦康纳、安妮·海瑟薇...
⏱️ 时长：169 分钟

📝 简介：...

📊 服务器状态：❌ 暂无
💡 建议：这部高分电影（⭐8.5）值得收藏！
🔍 下载提示：建议搜索 "星际穿越 2014 1080P 中字"
```

### Emby 查询（需 API Key）
```
Emby 有哪些科幻电影？
Emby 有《盗梦空间》吗？
我的服务器有多少部电影？
最近添加了什么电影？
```

### 🎯 每周推荐
```
本周推荐什么电影？
这周有什么好电影推荐
周末了，推荐部电影
最近工作很累，推荐部轻松的
```

### 背景记录
```
今天心情很好
最近工作很忙
最近对科幻题材感兴趣
```

### 观影记录
```
看了《星际穿越》，很震撼，诺兰的叙事手法太厉害了，评分 9/10
我的观影记录
```

### 个性化推荐
```
推荐科幻电影
推荐类似《星际穿越》的电影
Emby 上有什么高分电影推荐？
```

## 🎯 每周推荐算法

推荐系统会考虑以下因素：

1. **您的观影偏好** - 类型、导演、评分习惯
2. **Emby 评分** - 优先推荐高分佳作
3. **心情状态** - 累→轻松，开心→刺激
4. **工作状况** - 忙→犒劳，闲→深度
5. **时间因素** - 周末适合长片，工作日适合短片
6. **新片优先** - 最近添加的电影优先推荐
7. **避免重复** - 不会推荐已观看的电影

## 📊 记忆文件结构

```markdown
## 2026-03-03
### 《星际穿越》
- **评分**: 9/10
- **感受**: 诺兰的神作，时间概念太震撼了

## 每周观影计划
#### 第 10 周 (2026-03-03)
- **电影**: 《盗梦空间》
- **理由**: 您喜欢的悬疑类型；诺兰导演作品；高分佳作

## 背景记录
### 2026-03-03
- **心情**: 累
- **工作**: 最近备课很忙
- **最近关注**: 科幻电影
```
