# Wallet Setup

Configure your wallet for the Morpho yield skill.

## Interactive Setup (Recommended)

Run the setup wizard:
```bash
cd scripts
npx tsx setup.ts
```

This will guide you through wallet configuration and preferences.

## Manual Config File

Create `~/.config/morpho-yield/config.json`:

```json
{
  "wallet": {
    "source": "file",
    "path": "~/.clawd/vault/morpho.key"
  },
  "rpc": "https://rpc.moonwell.fi/main/evm/8453"
}
```

## Wallet Source Options

### Option 1: Private Key File (Recommended for Agents)

```json
{
  "wallet": {
    "source": "file",
    "path": "~/.clawd/vault/morpho.key"
  }
}
```

Create the key file:
```bash
mkdir -p ~/.clawd/vault
echo "0xYOUR_PRIVATE_KEY" > ~/.clawd/vault/morpho.key
chmod 600 ~/.clawd/vault/morpho.key
```

### Option 2: Environment Variable

```json
{
  "wallet": {
    "source": "env",
    "env": "MORPHO_PRIVATE_KEY"
  }
}
```

Set in your shell:
```bash
export MORPHO_PRIVATE_KEY="0x..."
```

### Option 3: 1Password (Most Secure)

```json
{
  "wallet": {
    "source": "1password",
    "item": "Morpho Bot Wallet",
    "field": "private_key"
  }
}
```

Create a 1Password item called "Morpho Bot Wallet" with a field "private_key" containing your key.

Scripts will use `op read` to fetch at runtime (requires 1Password CLI + desktop app).

## RPC Configuration

Default RPC is `https://rpc.moonwell.fi/main/evm/8453` (reliable, no rate limits).

Alternatives:
- **Alchemy:** `https://base-mainnet.g.alchemy.com/v2/YOUR_KEY`
- **Infura:** `https://base-mainnet.infura.io/v3/YOUR_KEY`
- **QuickNode:** Your QuickNode Base endpoint

## Creating a New Wallet

If you need a fresh wallet for this bot:

```bash
# Generate a new wallet (never share the output!)
node -e "console.log(require('viem/accounts').generatePrivateKey())"
```

Then:
1. Save the private key securely (file or 1Password)
2. Get the address from the private key
3. Fund it with USDC + small ETH for gas on Base
4. Configure as above

## Funding Your Wallet

The wallet needs:
- **USDC on Base** — the asset to deposit
- **ETH on Base** — for gas (~0.001 ETH per transaction)

Bridge from Ethereum mainnet via:
- [Base Bridge](https://bridge.base.org)
- [Across Protocol](https://across.to)
- [Stargate](https://stargate.finance)

## Verify Setup

Run the status script to confirm everything works:

```bash
cd scripts
npx tsx status.ts
```

Should show your wallet address, USDC balance, and current vault APY.

## Security Notes

- Never commit private keys to git
- Use restrictive file permissions: `chmod 600` for key files
- Consider using a dedicated hot wallet with limited funds
- The skill will warn if config files have loose permissions
