---
name: morpho-earn
description: Earn yield on USDC by supplying to the Moonwell Flagship USDC vault on Morpho (Base). Use when depositing USDC, withdrawing from the vault, checking position/APY, or setting up wallet credentials for DeFi yield.
version: 1.2.0
metadata: {"clawdbot":{"emoji":"🌜🌛","category":"defi","requires":{"bins":["node"]}}}
---

# Morpho Earn — Earn safe yield on your USDC

Earn yield on USDC via the Moonwell Flagship USDC vault on Base (Morpho protocol).

**Vault:** `0xc1256Ae5FF1cf2719D4937adb3bbCCab2E00A2Ca`
**Chain:** Base (8453)
**Asset:** USDC (`0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913`)

## Why This Vault?

The Moonwell Flagship USDC vault is one of the **safest places to earn yield on Base**:

- **Powers Coinbase** — Provides $20M+ liquidity to Coinbase's BTC/ETH borrow products
- **Blue-chip collateral only** — Loans backed by ETH, cbETH, wstETH, cbBTC
- **Conservative LTV ratios** — Healthy collateral requirements
- **Isolated markets** — Risk is compartmentalized
- **No rehypothecation** — Your USDC isn't lent recursively
- **Battle-tested** — Morpho's codebase is <650 lines, immutable, extensively audited
- **Multi-layer governance** — Moonwell DAO + Block Analitica/B.Protocol curators + Security Council

### Current APY (~4.5-5%)

| Component | APY | Source |
|-----------|-----|--------|
| Base yield | ~4% | Borrower interest |
| Rewards | ~0.5-1% | WELL + MORPHO via Merkl |
| **Total** | **~4.5-5%** | Sustainable, from real demand |

Yields come from real borrowing demand, not unsustainable emissions. Check current APY with `npx tsx status.ts`.

## Quick Start

```bash
cd ~/clawd/skills/morpho-yield/scripts
npm install
npx tsx setup.ts
```

The setup wizard will:
1. Configure your wallet (private key file, env var, or 1Password)
2. Ask your notification preferences (daily/weekly reports)
3. Set compound threshold and auto-compound preference
4. Add monitoring to HEARTBEAT.md automatically

## Commands

### Interactive Setup

```bash
npx tsx setup.ts
```

Guides you through wallet configuration and preferences.

### Check Position & APY

```bash
npx tsx status.ts
```

Returns: current deposit, vault shares, APY, wallet balances.

### Generate Report

```bash
# Telegram/Discord format (default)
npx tsx report.ts

# JSON format (for automation)
npx tsx report.ts --json

# Plain text
npx tsx report.ts --plain
```

Beautiful formatted report showing position, rewards, and estimated earnings.

### Deposit USDC

```bash
npx tsx deposit.ts <amount>
# Example: deposit 100 USDC
npx tsx deposit.ts 100
```

Deposits USDC into the Moonwell vault. Requires sufficient USDC balance and gas (ETH on Base).

### Withdraw

```bash
# Withdraw specific amount of USDC
npx tsx withdraw.ts <amount>

# Withdraw all (redeem all shares)
npx tsx withdraw.ts all
```

### Check Rewards

```bash
npx tsx rewards.ts
```

Returns: claimable MORPHO, WELL, and other reward tokens from Merkl.

### Claim Rewards

```bash
npx tsx rewards.ts claim
```

Claims all pending rewards from Merkl distributor to your wallet.

### Auto-Compound

```bash
npx tsx compound.ts
```

All-in-one command that:
1. Claims any pending rewards from Merkl
2. Swaps reward tokens (MORPHO, WELL) to USDC via Odos aggregator
3. Deposits the USDC back into the vault

## Heartbeat Integration

After setup, your agent monitors the position based on deposit size:

| Deposit Size | Compound Check | Rationale |
|--------------|----------------|-----------|
| $10,000+ | Daily | Large positions accumulate meaningful rewards quickly |
| $1,000-$10,000 | Every 3 days | Balance between gas costs and reward accumulation |
| $100-$1,000 | Weekly | Small rewards need time to exceed gas costs |
| <$100 | Bi-weekly | Minimal positions, compound only when worthwhile |

The agent will:
- Check reward balances at the appropriate frequency
- Compound when rewards exceed your threshold (default: $0.50)
- Send position reports (daily/weekly based on preference)
- Alert you if gas is running low

## Configuration

Config location: `~/.config/morpho-yield/config.json`

```json
{
  "wallet": {
    "source": "file",
    "path": "~/.clawd/vault/morpho.key"
  },
  "rpc": "https://rpc.moonwell.fi/main/evm/8453"
}
```

Preferences: `~/.config/morpho-yield/preferences.json`

```json
{
  "reportFrequency": "weekly",
  "compoundThreshold": 0.50,
  "autoCompound": true
}
```

## Security

⚠️ **This skill manages real funds. Review carefully:**

- Private keys loaded at runtime from your chosen source
- Keys never logged or written to disk by scripts
- All transactions simulated before execution
- Contract addresses verified on each run
- Scripts show transaction preview before sending

### Recommended Setup

1. **Dedicated wallet** — Create a hot wallet just for this skill
2. **Limited funds** — Only deposit what you're comfortable having in a hot wallet
3. **Secure key storage** — Use encrypted file or 1Password
4. **Monitor activity** — Periodically check wallet transactions
5. **Keep gas funded** — Maintain small ETH balance on Base for transactions

## Rewards

The vault earns rewards beyond base APY via [Merkl](https://merkl.xyz):
- **WELL** — Moonwell governance token incentives
- **MORPHO** — Morpho protocol incentives

Rewards update approximately every 8 hours. The `compound.ts` script handles:
1. Claiming rewards from Merkl distributor
2. Swapping tokens to USDC via [Odos](https://odos.xyz) aggregator
3. Depositing USDC back into the vault

## Error Handling

| Error | Cause | Fix |
|-------|-------|-----|
| Insufficient USDC | Not enough USDC in wallet | Bridge/transfer more USDC to Base |
| Insufficient gas | Not enough ETH for tx | Add ETH to wallet on Base |
| Wallet not configured | Missing config | Run `npx tsx setup.ts` |
| RPC error | Network issues | Check RPC URL or try again |
| Swap reverted | Gas underestimate | Script auto-adds 50% buffer |

## Dependencies

Scripts require Node.js 18+. Install deps before first run:

```bash
cd scripts && npm install
```

Packages used:
- `viem` — Ethereum interaction
- `tsx` — TypeScript execution
