#!/bin/bash\nset -e\n\ndate=${1:-$(date +%Y-%m-%d)}\nnotion_db=${NOTION_TASKS_DB:-}\n\ncat &lt;&lt; EOF\n📅 Morning Briefing for ${date}\n\n⏰ REMINDERS (Today)\nEOF\n\nremindctl today --plain | awk -F'\\t' '{print &quot;  &quot; substr(\$1,1,8) &quot; - &quot; \$5}' || echo &quot;  No reminders&quot;\n\necho\n\necho 📝 NOTION TASKS\necho\n\nif [ -n &quot;$notion_db&quot; ]; then\n  NOTION_KEY=\\$(cat ~/.config/notion/api_key)\n  curl -s -X POST &quot;https://api.notion.com/v1/databases/$notion_db/query&quot; \\\n    -H &quot;Authorization: Bearer \\$NOTION_KEY&quot; \\\n    -H &quot;Notion-Version: 2022-06-28&quot; \\\n    -H &quot;Content-Type: application/json&quot; \\\n    -d '{\"filter\": {\"property\": \"Status\", \"select\": {\"does_not_equal\": \"Done\"}}}' | \\\n  jq -r '.results[] | \"  [ ] \" + (.properties.Name.title[0].plain_text // &quot;Untitled&quot;)'\nelse\n  echo &quot;  Set NOTION_TASKS_DB env or specify DB ID&quot;\nfi\n\n# Output to stdout for Clawdbot to capture/use\n