# Supported DEXs

List of supported Decentralized Exchanges (DEXs) for token API endpoints including pair addresses, reserves, prices, swaps, and stats.

## Supported DEXs by Chain

### Ethereum (0x1)
- Uniswap V2
- Uniswap V3
- SushiSwap
- PancakeSwap
- Balancer V2
- Curve
- Bancor
- Kyber Network

### Polygon (0x89)
- QuickSwap
- Uniswap V3
- SushiSwap
- Balancer V2
- Curve

### BSC (0x38)
- PancakeSwap V2
- PancakeSwap V3
- Biswap
- BakerySwap
- MDEX

### Arbitrum (0xa4b1)
- Uniswap V3
- SushiSwap
- Balancer V2
- Curve

### Base (0x2105)
- Uniswap V3
- SushiSwap
- Balancer V2
- Curve

### Avalanche (0xa86a)
- Trader Joe
- Pangolin
- Uniswap V3
- SushiSwap

## Related Endpoints

- [getPairAddress](rules/getPairAddress.md) - Get DEX token pair address
- [getPairReserves](rules/getPairReserves.md) - Get DEX token pair reserves
- [getPairPrice](rules/getPairPrice.md) - Get DEX token pair price
- [getSwapsByPairAddress](rules/getSwapsByPairAddress__evm.md) - Get swap transactions by pair
- [getSwapsByTokenAddress](rules/getSwapsByTokenAddress__evm.md) - Get swap transactions by token
- [getTokenPairs](rules/getTokenPairs__evm.md) - Get token pairs by address

## Documentation

For complete list of supported DEXs per chain, see:
[https://docs.moralis.com/web3-data-api/evm/supported-dexs-token-api](https://docs.moralis.com/web3-data-api/evm/supported-dexs-token-api)
