# NFT Marketplaces

List of supported NFT marketplaces for NFT trade, floor price, and collection-related endpoints.

## Supported NFT Marketplaces by Chain

### Ethereum (0x1)
- OpenSea
- Blur
- X2Y2
- LookRare
- Rarible
- Foundation
- SuperRare
- NFTX
- Sudoswap
- Element Market

### Polygon (0x89)
- OpenSea
- Blur
- Tixel (Element)
- Rarible

### BSC (0x38)
- OpenSea
- Tixel (Element)
- NFTTrade

### Arbitrum (0xa4b1)
- OpenSea
- Blur
- Rarible

### Base (0x2105)
- OpenSea
- Blur
- Rarible

### Optimism (0xa)
- OpenSea
- Blur
- Rarible
- NFTX

### Avalanche (0xa86a)
- OpenSea
- Tixel (Element)
- Chillswitch

## Related Endpoints

- [getNFTTrades](rules/getNFTTrades.md) - Get NFT trades by collection
- [getNFTTradesByToken](rules/getNFTTradesByToken.md) - Get NFT trades by token
- [getNFTTradesByWallet](rules/getNFTTradesByWallet.md) - Get NFT trades by wallet address
- [getNFTFloorPriceByContract](rules/getNFTFloorPriceByContract.md) - Get NFT floor price by contract
- [getNFTFloorPriceByToken](rules/getNFTFloorPriceByToken.md) - Get NFT floor price by token
- [getNFTContractSalePrices](rules/getNFTContractSalePrices.md) - Get NFT sale prices by collection
- [getNFTHistoricalFloorPriceByContract](rules/getNFTHistoricalFloorPriceByContract.md) - Get historical NFT floor price by contract

## Documentation

For complete list of supported NFT marketplaces per chain, see:
[https://docs.moralis.com/web3-data-api/evm/nft-marketplaces](https://docs.moralis.com/web3-data-api/evm/nft-marketplaces)
