---
name: Monitor
slug: monitor
version: 1.0.2
description: Create monitors for anything. User defines what to check, skill handles scheduling and alerts.
changelog: Declared required binaries and optional env vars in metadata
metadata: {"clawdbot":{"emoji":"📡","requires":{"bins":["curl"],"env":{"optional":["PUSHOVER_TOKEN","PUSHOVER_USER"]}},"os":["linux","darwin","win32"]}}
---

## Data Storage

```
~/monitor/
├── monitors.json       # Monitor definitions
├── config.json         # Alert preferences
└── logs/               # Check results
    └── {name}/YYYY-MM.jsonl
```

Create on first use: `mkdir -p ~/monitor/logs`

## Scope

This skill:
- ✅ Stores monitor definitions in ~/monitor/
- ✅ Runs checks at specified intervals
- ✅ Alerts user on status changes

**Execution model:**
- User explicitly defines WHAT to monitor
- User grants any permissions/tools needed
- Skill only handles WHEN and ALERTING

This skill does NOT:
- ❌ Assume access to any service or endpoint
- ❌ Run checks without user-defined instructions
- ❌ Store credentials (user provides via environment or other skills)

## Requirements

**Required:**
- `curl` — for HTTP checks

**Optional (for alerts):**
- `PUSHOVER_TOKEN` / `PUSHOVER_USER` — for push notifications
- Webhook URL — user provides their own endpoint

**Used if available:**
- `openssl` — for SSL certificate checks
- `pgrep` — for process checks
- `df` — for disk space checks
- `nc` — for port checks

## Quick Reference

| Topic | File |
|-------|------|
| Monitor type examples | `templates.md` |
| Alert configuration | `alerts.md` |
| Analysis patterns | `insights.md` |

## Core Rules

### 1. User Defines Everything
When user requests a monitor:
1. **WHAT**: User specifies what to check
2. **HOW**: User provides method or grants tool access
3. **WHEN**: This skill handles interval
4. **ALERT**: This skill handles notifications

Example flow:
```
User: "Monitor my API at api.example.com every 5 minutes"
Agent: "I'll check HTTP status. Alert you on failures?"
User: "Yes, and check SSL cert too"
→ Monitor stored with user-defined checks
```

### 2. Monitor Definition
In ~/monitor/monitors.json:
```json
{
  "api_prod": {
    "description": "User's API health",
    "checks": [
      {"type": "http", "target": "https://api.example.com/health"},
      {"type": "ssl", "target": "api.example.com"}
    ],
    "interval": "5m",
    "alert_on": "change",
    "requires": [],
    "created": "2024-03-15"
  }
}
```

### 3. Common Check Types
User can request any of these (or others):

| Type | What it checks | Tool used |
|------|---------------|-----------|
| http | URL status + latency | curl |
| ssl | Certificate expiry | openssl |
| process | Process running | pgrep |
| disk | Free space | df |
| port | Port open | nc |
| custom | User-defined command | user specifies |

### 4. Confirmation Format
```
✅ Monitor: [description]
🔍 Checks: [what will be checked]
⏱️ Interval: [how often]
🔔 Alert: [when to notify]
🔧 Requires: [tools/access needed]
```

### 5. Alert on Change
- Alert when status changes (ok→fail, fail→ok)
- Include failure count
- Recovery message when back to OK
- Never spam repeated same-status

### 6. Permissions
The `requires` field lists what user granted:
- Empty = basic checks only (curl, df, pgrep)
- `["ssh:server1"]` = user granted SSH access
- `["docker"]` = user granted Docker access

Agent asks before assuming any access.
