---
name: mongodb-atlas
description: browse MongoDB Atlas Admin API specifications and execute operations (if credentials provided).
homepage: https://www.mongodb.com/docs/api/doc/atlas-admin-api-v2/
metadata: {"clawdbot":{"emoji":"🍃","requires":{"bins":["node"],"env":["ATLAS_CLIENT_ID","ATLAS_CLIENT_SECRET"]},"primaryEnv":""}}
---

# MongoDB Atlas Admin API

Tool to browse OpenAPI specifications for MongoDB Atlas.
**Note:** If `ATLAS_CLIENT_ID` and `ATLAS_CLIENT_SECRET` are configured in the environment, this tool can also execute live API calls. Without credentials, it functions as a read-only documentation browser.

## Commands

### 1. List API Catalog
List all available API categories or filter by keyword.

```bash
node {baseDir}/scripts/atlas-api.mjs catalog # list all categories
node {baseDir}/scripts/atlas-api.mjs catalog Clusters
```

### 2. Get API Details

Get full endpoint definition (method, path, params) for a specific Operation ID.

```bash
node {baseDir}/scripts/atlas-api.mjs detail listClusterDetails
```

### 3. Get Schema Definition

Get the data model schema for complex types.

```bash
node {baseDir}/scripts/atlas-api.mjs schema "#/components/schemas/ApiError"
```

### 4. Execute Live API Calls
Execute real HTTP requests against the Atlas API.

**Script:** `node {baseDir}/scripts/atlas-call.mjs <METHOD> <ENDPOINT> [flags]`

#### ⚠️ Mandatory Safety Protocol
**For any state-changing operation (POST, PUT, PATCH, DELETE):**
1.  **STOP & REVIEW**: You MUST NOT execute the command immediately.
2.  **PREVIEW**: Use `--dry-run` first to verify the payload and endpoint.
3.  **CONFIRM**: Display the full command and JSON body to the user.
4.  **EXECUTE**: Only run with `--yes` after receiving explicit user approval.

#### Usage Examples

**1. Read-Only (Safe)**

```bash
node {baseDir}/scripts/atlas-call.mjs GET groups/{groupId}/clusters
```

**2. Create/Modify (RISKY - Require Approval)**

```bash
node {baseDir}/scripts/atlas-call.mjs POST groups/{groupId}/clusters \
  --data '{"name":"DemoCluster", "providerSettings":{...}}' \
  --dry-run
```

#### Options

* `-d, --data <json>`: Request body string (ensure proper JSON escaping).
* `-p, --params <json>`: Query parameters.
* `--dry-run`: Print the request details without executing (Recommended for verification).
* `--yes`: Skip interactive confirmation (Use CAREFULLY).

#### Environment

Requires `ATLAS_CLIENT_ID` and `ATLAS_CLIENT_SECRET` to be set.

## Core Categories

(Use `catalog` command to see the full list of 50+ categories)

* **Clusters** / **Cloud Backups**
* **Projects** / **Organizations**
* **Database Users** / **Custom Database Roles**
* **Alerts** / **Alert Configurations**
* **Monitoring and Logs** / **Events**
* **Network Peering** / **Private Endpoint Services**
* **Serverless Instances**
* **Access Tracking** / **Auditing**
