---
name: Money
description: Personal finance guidance with practical rules for saving, investing, and avoiding common traps.
metadata: {"clawdbot":{"emoji":"💰","os":["linux","darwin","win32"]}}
---

# Personal Finance Rules

## Before Any Advice
- Ask about existing debts, income stability, and country of residence — generic advice without context is dangerous
- High-interest debt (credit cards, payday loans) must be paid first — no investment beats 20%+ guaranteed return of eliminating debt
- Emergency fund of 3-6 months expenses comes before investing — without it, any crisis forces selling at the worst time

## Inflation Reality
- Cash in savings accounts loses purchasing power every year — 2-3% inflation means €10,000 becomes €7,400 in real terms after 10 years
- Long-term projections must use real returns (after inflation) — 7% real is honest, 10% nominal is misleading
- "Safe" bonds can lose to inflation — being conservative isn't the same as being safe

## Investment Math
- Fees compound against you — 1% annual fee takes 25% of returns over 30 years
- Time in market beats timing the market — missing the 10 best days in a decade cuts returns in half
- Past performance predicts nothing — last year's top fund is often next year's loser
- Diversification is the only free lunch — single stocks are gambling, broad index funds are investing

## Tax Awareness
- Every country has tax-advantaged accounts — ask which ones apply before recommending where to invest
- Capital gains, dividends, and interest are taxed differently — account type matters
- Tax loss harvesting and rebalancing have tax implications — don't ignore them
- Retirement accounts have withdrawal rules — early access often means penalties

## Behavioral Traps
- Lifestyle inflation silently erases raises — a €5,000 raise that becomes €5,000 more spending changes nothing
- Loss aversion makes people sell winners and hold losers — the opposite of what works
- "I'll start investing when I have more money" is the most expensive delay — small amounts now beat large amounts later
- Checking investments daily increases bad decisions — less attention often means better returns

## Insurance First
- Protect existing assets before growing them — health, disability, liability coverage
- Life insurance only matters if someone depends on your income
- High deductibles with lower premiums often make sense for those with emergency funds
- Insurance is for catastrophic risks, not minor inconveniences

## Debt Hierarchy
- Not all debt is equal — mortgage at 3% is different from credit card at 22%
- Paying minimums on low-interest debt while investing the difference often wins mathematically
- Student loans and mortgages may have tax benefits — factor them in
- Debt-free feels good but isn't always optimal — opportunity cost matters

## Practical Automation
- Pay yourself first: automate savings on payday — what's left is what you spend
- Automate bill payments to avoid late fees and credit damage
- Increase savings rate with every raise — split the raise between lifestyle and saving
- Annual rebalancing is enough — more frequent trading usually hurts

## Red Flags
- Any "guaranteed" high returns — if it sounds too good, it is
- Pressure to decide quickly — legitimate opportunities don't vanish in 24 hours
- Complex products you don't understand — complexity hides fees
- Anyone who benefits from your investment decision giving you advice
