---
name: money-knowledge
version: 1.0.0
description: 金钱与财富知识助手。提供关于金钱的基本概念、理财知识、投资原则、财富思维等方面的内容。适用于：1) 了解金钱的基本知识；2) 学习理财和投资原则；3) 培养财富思维；4) 了解经济学基础概念。
---

# 金钱与财富知识助手

本技能帮助你了解金钱、财富和理财相关的基础知识。

## 金钱基础知识

### 货币的本质
- 货币是交换媒介
- 价值存储功能
- 计价单位作用

### 常见货币类型
- 现金、存款
- 数字货币（比特币、以太坊等）
- 法定货币（人民币、美元等）

## 理财基础知识

### 理财金字塔

```
       /\
      /  \
     /投资\
    /______\
   /储蓄保险\
  /__________\
 /基本支出工资\
/______________\
```

### 投资原则
1. **风险与收益成正比** - 高收益伴随高风险
2. **分散投资** - 不要把鸡蛋放在一个篮子里
3. **长期投资** - 时间是投资者最好的朋友
4. **不懂不投** - 只投资自己了解的领域

## 财富思维

### 核心观念
- **收入多元化** - 不仅靠工资
- **支出控制** - 养成储蓄习惯
- **资产配置** - 合理分配投资
- **复利效应** - 让钱为你工作

### 经典法则
- **50/30/20 法则**
  - 50% 必要支出
  - 30% 弹性消费
  - 20% 储蓄投资

- **72 法则**
  - 72 ÷ 年化收益率 = 资金翻倍年数

## 投资品种

| 类型 | 风险 | 收益 | 流动性 |
|------|------|------|--------|
| 银行存款 | 低 | 低 | 高 |
| 债券 | 中低 | 中 | 中 |
| 股票 | 高 | 高 | 高 |
| 基金 | 中高 | 中高 | 高 |
| 数字货币 | 极高 | 极高 | 高 |

## 经济学基础

### 供需关系
- 需求增加 → 价格上涨
- 供给增加 → 价格下降

### 通货膨胀
- 物价水平持续上涨
- 货币购买力下降
- 储蓄实际价值缩水

### 利率
- 借钱的价格
- 存款的回报
- 影响投资决策的重要因素

## 注意事项

- 投资有风险，入市需谨慎
- 根据自身风险承受能力选择投资品种
- 建议分散投资，不要集中持仓
- 持续学习，提高财商
- 必要时咨询专业理财顾问
