# Pricing: Get a Number, Not Theory

## The Simple Method (Works)

1. Set a price that makes you slightly uncomfortable
2. Offer to 10 real people
3. 0 buy → lower price OR fix value proposition
4. 2-3 buy → probably right
5. All buy immediately → raise price

Surveys lie. Credit cards don't.

## Value-Based Discovery (5 Questions)

In customer conversations:
1. "What problem does this solve for you?"
2. "How do you solve it today? What does that cost in time/money?"
3. "If this saved you X hours/week, what would that be worth?"
4. "What would you compare this to?"
5. "What would make it worth double?"

Use their answers to anchor your price to value they stated.

## The Math That Matters

### LTV (Lifetime Value)
```
SaaS: LTV = (Monthly × Margin) ÷ Churn
Example: $50 × 80% ÷ 5% = $800

E-commerce: LTV = Order Value × Frequency × Lifespan
Example: $75 × 4/year × 3 years = $900
```

### Payback Period
```
Months = CAC ÷ (Monthly Revenue × Margin)
Example: $200 ÷ ($50 × 80%) = 5 months
Target: <12 months
```

### LTV:CAC
```
Ratio = LTV ÷ CAC
Example: $800 ÷ $200 = 4:1
Target: >3:1
```

## Pricing Power

Your price is sustainable if you have:
- **Lock-in**: Data, integrations, workflows built on you
- **Switching costs**: Learning curve, migration pain
- **Network effects**: More users = more value

Without these, you compete on price. With them, you set price.

## Tier Structure (The Decoy Trick)

Three tiers work. Make the middle tier a decoy that pushes to the one you want:

| | Starter | Pro (DECOY) | Team |
|---|---------|-------------|------|
| Price | $19/mo | $49/mo | $59/mo |
| Core features | ✓ | ✓ | ✓ |
| Key feature | Limited | Unlimited | Unlimited |
| Team features | — | — | ✓ |

Pro at $49 makes Team at $59 look like obvious value.

## Annual vs Monthly

- Discount: 15-20% (2 months free)
- More than 20% devalues the product
- Frame as savings: "$99/year (save $79)" not "17% off"
- Default UI to annual, monthly as alternative
- Target mix: 60% annual, 40% monthly

## When to Raise Prices

- Demand exceeds your capacity
- Support is overwhelming
- LTV:CAC > 5:1
- 6+ months since last raise
- Customers stop complaining about price

## What to Avoid

- **Copying competitor prices** without understanding their costs/value
- **Psychology tricks as strategy** — $9.99 vs $10 is 2% of the equation
- **Surveys to set price** — people don't know what they'd pay
- **Discounting to close** — trains customers to wait for deals
- **Grandfathering everyone forever** — creates pricing debt
