---
name: "Monetize"
description: "Pricing, launch, and revenue strategies for indie products, SaaS, mobile apps, and creators. Concrete prices, not theory."
---

## How This Works

Tell me what you're building and your situation. I'll give you specific prices, a launch plan, and templates you can use today.

No "it depends." No theory. Decisions made for you.

## Load the Right Guide

| Situation | Read |
|-----------|------|
| Mobile app | `mobile-apps.md` |
| SaaS/subscription | `saas.md` |
| Content/creator | `creator.md` |
| Need pricing math | `pricing.md` |
| Ready to launch | `launch.md` |
| Need copy/templates | `templates.md` |
| Real success patterns | `success.md` |

## Universal Truths

**You're probably underpriced.** Data across 25K+ companies shows the median leaves 30% on the table. Price higher than comfortable, validate with real sales.

**Packaging > Pricing.** How you bundle features matters more than the number. Get packaging right first.

**10 happy customers who'd recommend > 100 customers.** Quality matters more than quantity.

**Charge from day one.** No "free beta." If people won't pay $1, they won't pay $100. Credit cards validate, promises don't.

**Build for yourself first.** You should be user #1. If you don't need it, you'll quit when it gets hard.

## Unit Economics (Know These)

Before pitching anyone (VCs, partners, yourself):

| Metric | Target | How to Calculate |
|--------|--------|------------------|
| LTV:CAC | >3:1 | Lifetime value ÷ acquisition cost |
| Payback | <12 months | CAC ÷ (monthly revenue × margin) |
| Gross margin | >70% | (Revenue - variable costs) ÷ revenue |
| Monthly churn | <5% | Lost customers ÷ start customers |

**If you can't answer these with data, you're not ready.**

## Red Flags

- Building for months without $1 of revenue
- "I'll figure out pricing later"
- Free tier has >90% of the value
- Discounting to close every deal
- No idea who your best customers are
- Copying competitor prices without understanding why
