// Auto-generated GraphQL types and interfaces
// This file is automatically generated from GraphQL schema

export interface GraphQLVariables {
  [key: string]: unknown
}

export interface GetAccountsResponse {
  accounts: {
    edges: Array<{
      node: {
        id: string
        displayName: string
        syncDisabled: boolean
        deactivatedAt?: string
        isHidden: boolean
        isAsset: boolean
        includeInNetWorth: boolean
        currentBalance: number
        availableBalance?: number
        dataProvider: string
        dataProviderAccountId?: string
        institutionName: string
        mask?: string
        createdAt: string
        updatedAt: string
        importedFromMint: boolean
        accountTypeId: number
        accountSubtypeId: number
        type: {
          id: number
          name: string
          display: string
        }
        subtype: {
          id: number
          name: string
          display: string
        }
        credential?: {
          id: string
          institutionId: string
          institutionName: string
        }
      }
    }>
  }
}

export interface GetTransactionsResponse {
  transactions: {
    edges: Array<{
      node: {
        id: string
        amount: number
        date: string
        merchantName: string
        categoryId?: string
        category?: {
          id: string
          name: string
          icon?: string
          order: number
          group?: {
            id: string
            name: string
            type: string
          }
        }
        accountId: string
        account: {
          id: string
          displayName: string
          institutionName: string
          mask?: string
        }
        notes?: string
        isRecurring: boolean
        needsReview: boolean
        reviewedAt?: string
        createdAt: string
        updatedAt: string
        importedFromMint: boolean
        plaidTransactionId?: string
        dataProvider: string
        dataProviderTransactionId?: string
        hasTags: boolean
        tags?: Array<{
          id: string
          name: string
          color: string
          order: number
        }>
        isHidden: boolean
        hiddenAt?: string
        isSplit: boolean
        splits?: Array<{
          id: string
          amount: number
          categoryId?: string
          category?: {
            id: string
            name: string
          }
          notes?: string
        }>
        originalDescription?: string
        isCashIn: boolean
        isCashOut: boolean
      }
    }>
    totalCount: number
    pageInfo: {
      hasNextPage: boolean
      hasPreviousPage: boolean
      startCursor?: string
      endCursor?: string
    }
  }
}

export interface GetBudgetsResponse {
  budgets: {
    id: string
    startDate: string
    endDate: string
    categories: Array<{
      id: string
      name: string
      budgetAmount: number
      spentAmount: number
      remainingAmount: number
      percentSpent: number
      isFlexible: boolean
      flexibleAmounts?: Array<{
        month: string
        amount: number
      }>
    }>
  }[]
}

export interface GetHoldingsResponse {
  holdings: {
    edges: Array<{
      node: {
        id: string
        accountId: string
        securityId: string
        security: {
          id: string
          symbol: string
          name: string
          type: string
          price: number
          priceDate: string
        }
        quantity: number
        price: number
        value: number
        costBasis?: number
        unrealizedGainLoss?: number
        percentOfPortfolio: number
      }
    }>
  }
}

export interface CreateTransactionResponse {
  createTransaction: {
    transaction: {
      id: string
      amount: number
      date: string
      merchantName: string
      categoryId?: string
      accountId: string
      notes?: string
    }
    errors?: Array<{
      message: string
      field?: string
    }>
  }
}

export interface UpdateTransactionResponse {
  updateTransaction: {
    transaction: {
      id: string
      amount: number
      date: string
      merchantName: string
      categoryId?: string
      accountId: string
      notes?: string
    }
    errors?: Array<{
      message: string
      field?: string
    }>
  }
}

export interface DeleteTransactionResponse {
  deleteTransaction: {
    success: boolean
    errors?: Array<{
      message: string
    }>
  }
}

export interface LoginResponse {
  login: {
    token: string
    user: {
      id: string
      email: string
      firstName?: string
      lastName?: string
    }
    errors?: Array<{
      message: string
      field?: string
    }>
  }
}

export interface MfaResponse {
  multiFactorAuth: {
    token: string
    errors?: Array<{
      message: string
      field?: string
    }>
  }
}

// GraphQL Operation Types
export type GraphQLOperation = 
  | 'GetAccounts'
  | 'GetTransactions'
  | 'GetBudgets'
  | 'GetHoldings'
  | 'CreateTransaction'
  | 'UpdateTransaction'
  | 'DeleteTransaction'
  | 'Login'
  | 'MultiFactorAuth'