---
name: moments-copy-critic
description: "Persuasive copy analysis for WeChat Moments. Use when users need to: (1) Evaluate the persuasiveness of WeChat Moments posts, (2) Improve conversion or engagement of social media copy, (3) Get actionable feedback on personal or business WeChat Moments content, (4) Learn what makes copy more convincing and effective"
---

# WeChat Moments Copy Critic

## Overview

Analyze and improve the persuasiveness of WeChat Moments copy. This skill focuses on practical, actionable feedback to make posts more convincing, engaging, and effective at driving reader action.

## Quick Evaluation Framework

Use this 5-point checklist for rapid assessment:

**The 5 Elements of Persuasion**

1. **Hook (钩子)** - Does the first sentence grab attention?
   - Uses curiosity, controversy, or emotional trigger
   - Avoids generic openings ("Today is a good day")
   - Creates urgency or relevance

2. **Pain Point (痛点)** - Does it resonate with reader's problems?
   - Identifies a real, relatable issue
   - Shows understanding of reader's situation
   - Creates emotional connection

3. **Solution/Benefit (利益点)** - Does it offer clear value?
   - Addresses the pain point directly
   - States the benefit clearly, not just features
   - Makes the solution feel achievable

4. **Proof/Credibility (可信度)** - Is the claim believable?
   - Provides specific evidence or examples
   - Uses numbers, stories, or testimonials
   - Builds trust with expertise or experience

5. **Call to Action (行动指令)** - Does it tell readers what to do?
   - Clear, specific action requested
   - Low barrier to entry
   - Relevant to the content

## Detailed Analysis Process

### Step 1: Identify the Goal

Determine what the copy aims to achieve:

- **Information sharing**: Educating or informing
- **Product/service promotion**: Driving sales or inquiries
- **Personal branding**: Building authority or likability
- **Engagement**: Getting likes, comments, or shares
- **Trust building**: Establishing credibility

### Step 2: Evaluate Against 5 Elements

For each element, score 1-5 and provide specific feedback:

**Hook Analysis**

```
Score: ___/5
Strength: [What works well]
Weakness: [What's missing or weak]
Improvement: [Specific suggestion]
```

**Pain Point Analysis**

```
Score: ___/5
Strength: [What works well]
Weakness: [What's missing or weak]
Improvement: [Specific suggestion]
```

Repeat for all 5 elements.

### Step 3: Provide Actionable Improvements

Give concrete rewrite suggestions:

- **Version A (Minor tweaks)**: Keep original structure, fix specific issues
- **Version B (Better hook)**: Start with a stronger opening
- **Version C (Complete rewrite)**: Restructure for maximum persuasion

### Step 4: Explain the "Why"

For each improvement, explain the psychological principle:

- **Why this change**: The reasoning behind the suggestion
- **Expected outcome**: What result to expect
- **When to use**: Context for when this approach works best

## Common Weaknesses & Fixes

### Weak Hook

**Problem**: Generic, boring, or confusing opening

```
❌ "Today I went to the factory to check the stove production"
✅ "Found a critical detail in our stove assembly line that could save you 30% on fuel costs"
```

**Fix**: Start with:

- A surprising fact or statistic
- A question that provokes thought
- A bold statement or claim
- A relatable situation or story

### No Clear Pain Point

**Problem**: Doesn't connect with reader's needs

```
❌ "Our stoves are very powerful and can cook food quickly"
✅ "Tired of half-cooked food at family gatherings? This happens when your stove can't maintain temperature"
```

**Fix**:

- Describe a frustrating situation readers face
- Use "you" language to make it personal
- Show you understand their struggle
- Make the pain feel urgent

### Weak Benefits

**Problem**: Focuses on features instead of benefits

```
❌ "This stove has 3000W power and automatic temperature control"
✅ "Cook a full 10-course meal in half the time, with every dish at perfect temperature"
```

**Fix**:

- Translate features to benefits (What does this DO for me?)
- Use concrete, measurable outcomes
- Paint a picture of the result
- Make it emotional, not just logical

### Low Credibility

**Problem**: Claims without proof

```
❌ "This is the best stove on the market"
✅ "After 15 years and 50,000+ stoves manufactured, we've reduced defect rates to 0.1% - the lowest in the industry"
```

**Fix**:

- Add specific numbers and statistics
- Share personal experience or stories
- Show behind-the-scenes proof
- Use testimonials or case studies

### No Action Instruction

**Problem**: Doesn't tell readers what to do

```
❌ "Our new stove is now available"
✅ "Comment 'demo' and I'll send you a video of this stove in action at a busy restaurant kitchen"
```

**Fix**:

- Be specific about the desired action
- Make it easy (low friction)
- Give a reason why (what's in it for them)
- Create urgency if appropriate

## Scoring Rubric

Use this rubric to rate each element (1-5 points):

**Hook**

- 1: Generic, boring opening
- 2: Slightly interesting but not compelling
- 3: Decent hook, some engagement
- 4: Strong hook, good attention-grabber
- 5: Outstanding hook, impossible to scroll past

**Pain Point**

- 1: No connection to reader's problems
- 2: Vague mention of issues
- 3: Identifies real pain points
- 4: Strong emotional connection to pain
- 5: Perfectly articulates reader's struggle

**Benefit**

- 1: Only features mentioned
- 2: Weak benefit, unclear value
- 3: Clear benefit, some appeal
- 4: Strong, compelling benefit
- 5: Irresistible benefit, clearly valuable

**Credibility**

- 1: No proof or evidence
- 2: Weak or generic proof
- 3: Some credible evidence
- 4: Strong, specific proof
- 5: Highly credible, authoritative proof

**Call to Action**

- 1: No action requested
- 2: Vague action instruction
- 3: Clear but uninspiring CTA
- 4: Strong, compelling CTA
- 5: Perfect CTA, high conversion potential

**Total Score**: Sum of all 5 elements (5-25)

- 5-10: Needs complete rewrite
- 11-15: Significant improvements needed
- 16-20: Good, minor tweaks needed
- 21-25: Excellent copy

## Copy Structure Templates

### Template 1: Problem-Agitate-Solve (PAS)

适用于：产品推广、解决方案分享

```
[PROBLEM] Describe a specific pain point readers face
[AGITATE] Show why this is frustrating and urgent
[SOLVE] Present your solution as the answer
[PROOF] Add credibility with evidence
[CTA] Call to action
```

### Template 2: Story-Benefit-CTA

适用于：个人经历、案例分享

```
[STORY] Brief, relatable story about problem/solution
[LESSON] Key insight or takeaway
[BENEFIT] What readers gain
[CTA] Action to take
```

### Template 3: Question-Answer-Proof

适用于：知识分享、专业见解

```
[HOOK] Provocative question
[ANSWER] Clear, valuable answer
[EXAMPLE] Concrete example or proof
[CTA] Engagement request (comment/share)
```

## Before & After Examples

### Example 1: Product Promotion

**Before (Score: 8/25)**

```
今天去工厂看了新生产的集成灶，质量很好，火力很大，欢迎大家来选购。
```

**Analysis:**

- Hook: 1/5 (Generic opening)
- Pain Point: 1/5 (None)
- Benefit: 2/5 (Weak: "火力很大")
- Credibility: 1/5 (No proof)
- CTA: 2/5 (Vague: "欢迎选购")

**After (Score: 22/25)**

```
发现很多家庭做年夜饭时，最后一道菜总是半生不熟😤

核心问题不是厨艺，是燃气灶火力跟不上。大锅炒菜温度一上不来，食物就蔫了。

我们新研发的5.2kW猛火灶，实测从冷锅到爆炒只需3秒⚡️，就算同时炒8个菜都能保持高温。

今天拍了段实拍视频：在工厂里用这个灶炒了10道硬菜，每道菜都刚好出锅。评论"演示"私发给你看看👇
```

**Improvements:**

- Hook: 4/5 (Specific, relatable problem)
- Pain Point: 5/5 (Perfectly articulates common frustration)
- Benefit: 4/5 (Clear, measurable outcome)
- Credibility: 4/5 (Specific evidence: "3秒", "10道菜")
- CTA: 5/5 (Clear, specific, low-friction action)

### Example 2: Behind-the-Scenes

**Before (Score: 9/25)**

```
今天在工厂加班，为了赶这批壁炉的订单。大家都很辛苦，但我们一定会按时交货的。
```

**Analysis:**

- Hook: 2/5 (Slightly personal but boring)
- Pain Point: 1/5 (None for readers)
- Benefit: 2/5 (Vague: "按时交货")
- Credibility: 3/5 (Shows effort)
- CTA: 1/5 (None)

**After (Score: 20/25)**

```
连续第3天晚上11点下班了🌙

有个客户下周要开新餐厅，急需20台壁炉。如果赶不出来，开业当天可能就出事故。

今天凌晨2点，车间老王发现一台壁炉的温控器有0.5度误差，二话没说直接拆了重装。

这就是为什么我们敢承诺：晚交货1天，赔款1000元。做产品，不能拿客户声誉冒险💪
```

**Improvements:**

- Hook: 4/5 (Creates curiosity about加班原因)
- Pain Point: 3/5 (Connects to business continuity)
- Benefit: 4/5 (Clear guarantee value)
- Credibility: 5/5 (Specific story, concrete actions)
- CTA: 4/5 (Implied: trust our commitment)

## Common Mistakes to Avoid

1. **Being too generic**: Vague claims like "high quality" or "great service"
2. **Talking about yourself**: Too much "we did this" instead of "you get this"
3. **No emotional trigger**: Purely logical, no feeling involved
4. **Too long**: Wall of text that people won't read
5. **No story or proof**: Empty claims without evidence
6. **Weak CTA**: "欢迎联系" instead of specific action
7. **Missing the "so what"**: Listing features without explaining benefit
8. **No personality**: Sounding like a company announcement instead of a real person

## Feedback Format

When providing feedback, use this structure:

```
📊 OVERALL SCORE: ___/25

✅ STRENGTHS:
- [What works well]

❌ WEAKNESSES:
- [What's missing or weak]

🔧 SPECIFIC IMPROVEMENTS:

1. Hook Improvement:
   Current: [Current opening]
   Better: [Stronger hook]
   Why: [Psychological principle]

2. Pain Point Enhancement:
   Current: [Current pain point (or none)]
   Better: [Clearer pain point]
   Why: [Why this resonates better]

[Continue for all 5 elements]

📝 REWRITE VERSIONS:

Version A (Minor tweaks):
[Optimized original]

Version B (Better hook):
[Stronger opening]

Version C (Complete rewrite):
[Restructured for maximum impact]

💡 KEY TAKEAWAYS:
- [3-5 core principles to remember]
```

## When to Use This Skill

Trigger this skill when users say:

- "帮我看看这条朋友圈文案怎么样"
- "这条文案有说服力吗"
- "如何让这条朋友圈更吸引人"
- "帮我优化这条文案"
- "朋友圈发什么内容比较好"
- "这条文案能带来转化吗"

Or when the context involves:

- WeChat Moments posts being evaluated
- Social media copy needing improvement
- Persuasion and conversion optimization
- Personal or business brand building on social platforms
