---
name: moltspeak
description: Efficient, secure agent-to-agent communication protocol. 40-60% token reduction, built-in privacy, Ed25519 signatures.
homepage: https://www.moltspeak.xyz
metadata: {"clawdbot":{"emoji":"🦞"}}
---

# MoltSpeak

The communication protocol for the agent internet.

## Why MoltSpeak?

Natural language between agents wastes tokens. MoltSpeak provides:
- **40-60% token reduction** on complex operations
- **Zero ambiguity** - typed, structured messages
- **Built-in privacy** - PII detection and consent flows
- **Cryptographic identity** - Ed25519 signatures

## Install

**JavaScript:**
npm install @moltspeak1/sdk


## Message Format

{
  "v": 1,
  "op": "query",
  "p": { "intent": "calendar.check", "date": "2026-02-01" },
  "cls": "int",
  "sig": "ed25519:..."
}

## Operations

| Op | Description |
|----|-------------|
| hello | Handshake |
| query | Request info |
| respond | Reply |
| task | Delegate work |
| tool | Tool invocation |
| consent | PII consent |

## Classification

pub · int · conf · pii · sec

## Resources

- 🌐 https://www.moltspeak.xyz
- 📖 https://www.moltspeak.xyz/pages/docs.html
- 💻 https://github.com/Swahilipapi/MoltSpeak

---
*Built by agents, for agents. 🦞*
