# Moltpho Purchasing Policies

This document defines the purchasing policies, limits, and behavioral rules for the Moltpho shopping skill. These policies govern both autonomous and proactive purchasing behavior.

---

## Purchasing Modes

Moltpho supports two purchasing modes, both controlled by the owner via the portal:

### 1. Autonomous Purchasing

**Portal label:** "Buy when I ask"
**Default:** ON

When enabled, the agent can complete purchases without explicit confirmation when the owner requests an item. The agent will:
- Search for the requested item
- Create a quote
- Complete the x402 payment flow
- Place the order

**Requirements to proceed:**
- Owner has enabled autonomous purchasing
- Item keywords not in denied list or system blocklist
- Total cost <= available credit
- Total cost <= per-order cap (if set)
- Total cost <= daily cap (if set)
- Confidence >= 0.7 threshold
- Shipping profile exists and is valid (US address)

---

### 2. Proactive Purchasing

**Portal label:** "Buy when my agent thinks I need it"
**Default:** ON

When enabled, the agent may initiate purchases based on detected needs in conversation, without explicit purchase requests.

**Requirements to proceed (all must be true):**
- Owner has enabled proactive purchasing
- Conversation contains a "need signal" (see below)
- Item is classified as low-risk
- Price <= proactive cap (see Limits section)
- All autonomous purchasing requirements also met

**Need Signals:**

| Type | Examples | Confidence |
|------|----------|------------|
| Explicit | "I need", "we're out of", "buy", "order", "replace", "get me" | 1.0 |
| Strong implied | "We ran out", "This is broken", "I can't find mine" | 0.8 |
| Weak implied | "That would be nice to have", "I've been thinking about" | 0.5 (do not buy) |

**Low-Risk Item Categories:**
- Household essentials
- Office supplies
- Cables and adapters
- Basic kitchen items
- Toiletries

---

## Limits & Caps

### Per-Order Cap

**Field:** `per_order_cap`
**Default:** none (unlimited)

Maximum amount for a single order. Orders exceeding this cap will be blocked.

**Example:** If set to $50, an order totaling $75 will be rejected with `INSUFFICIENT_CREDIT` (even if balance is sufficient).

---

### Daily Cap

**Field:** `daily_cap`
**Default:** none (unlimited)

Maximum total spending in a 24-hour period (midnight to midnight in owner's timezone).

**Example:** If set to $100 and $85 has been spent today, a $25 order will be rejected.

---

### Proactive Cap

**Calculation:** `min(per_order_cap, $75)`

Proactive purchases have a stricter limit to prevent unexpected large purchases.

**Examples:**
| per_order_cap | Proactive Cap |
|---------------|---------------|
| none | $75 |
| $100 | $75 |
| $50 | $50 |
| $30 | $30 |

---

## Category Controls

Owners can configure keyword-based allowlists and denylists to control what categories of items can be purchased.

### Keyword Matching Rules

1. **Case-insensitive:** "Weapon" matches "weapon", "WEAPON", "WeApOn"
2. **Word boundary matching:** Keywords match whole words only
3. **Applied to:** Product title, brand, category hierarchy, bullet points
4. **Match priority:** Denylist > Allowlist (if both match, item is denied)
5. **System blocklist:** Always checked last, cannot be overridden

### Keyword Format

```json
{
  "category_allowlist": ["office supplies", "household"],
  "category_denylist": ["electronics", "luxury", "jewelry"]
}
```

### Wildcard Syntax

| Syntax | Match Type | Example | Matches | Does NOT Match |
|--------|------------|---------|---------|----------------|
| `keyword` | Word boundary (default) | `gun` | "water gun", "gun safe" | "burgundy", "tongue" |
| `*keyword` | Suffix match | `*phone` | "smartphone", "iPhone" | "phone case" |
| `keyword*` | Prefix match | `phone*` | "phone charger", "phone mount" | "smartphone" |
| `*keyword*` | Contains | `*phone*` | "smartphone", "phone case" | "telephony" |

### Configuration Limits

- Maximum 50 keywords total (allowlist + denylist combined)
- Keywords compiled to regex at policy save time
- Matching runs in <10ms for typical product metadata

---

## System Blocklist

The following categories are ALWAYS blocked regardless of owner settings. This list is immutable and enforced at the system level.

**Items that can NEVER be purchased:**

| Category | Examples |
|----------|----------|
| Weapons | Firearms, ammunition, knives (non-kitchen), tactical gear |
| Controlled substances | Illegal drugs, drug paraphernalia |
| Prescription medications | Any Rx-required medication |
| Tobacco/Nicotine | Cigarettes, vapes, e-liquids, nicotine patches |
| Alcohol | Beer, wine, spirits, alcohol-containing products |
| Adult content | Explicit materials, adult toys |
| Hazardous materials | Explosives, flammable chemicals, toxic substances |

**Enforcement:** System blocklist matching runs after all other checks. Items matching the blocklist will be rejected with a generic "Item not available for purchase" message (does not disclose blocklist matching).

---

## Confidence Scoring

The agent assigns a confidence score (0.0 to 1.0) to each potential purchase based on the strength of the purchase signal.

### Confidence Levels

| Score | Description | Action |
|-------|-------------|--------|
| 1.0 | Explicit request ("Buy this", "Order now") | Proceed |
| 0.8 | Strong implied need ("We're out of", "This broke") | Proceed |
| 0.7 | Threshold minimum | Proceed (cautiously) |
| 0.5 | Weak implied convenience | Do NOT buy |
| 0.0 | No purchase signal | Do NOT buy |

### Budget Signal Handling

When financial constraint signals are detected, confidence is reduced:

**Trigger phrases:**
- "money is tight"
- "on a budget"
- "can't afford"
- "too expensive"
- "need to save"
- "cutting costs"

**Confidence reduction:** 0.3 to 0.5 depending on signal strength

**Example:**
- Owner says "We need paper towels, but money is tight this month"
- Base confidence: 0.8 (strong implied need)
- Reduction: -0.4 (budget signal)
- Final confidence: 0.4 (below threshold, do NOT buy)

**Note:** Budget signals reduce confidence but don't create an absolute block. If the base confidence is high enough (e.g., 1.0 explicit request), the purchase may still proceed.

---

## Quote & Pricing

### Quote TTL

**Duration:** Fixed 10 minutes from creation
**Behavior:** Quotes cannot be extended; a new quote must be created after expiry

### Pricing

| Component | Value | Notes |
|-----------|-------|-------|
| Base price | Amazon offer price | Current market price |
| Markup | +10% (1000 BPS) | Covers operational costs, gas fees |
| Final price | Moltpho price | Only this price is shown to agents/owners |

**Note:** The markup is not itemized or disclosed. Agents and owners see only the final Moltpho price.

### Price Tolerance

| Tolerance | Behavior |
|-----------|----------|
| <= 2% increase | Proceed silently |
| > 2% increase | Return `409 PRICE_CHANGED`, require re-quote |

**Example:** If quoted price was $100.00 and current price is $101.50 (+1.5%), the order proceeds. If current price is $103.00 (+3%), the order fails with `PRICE_CHANGED`.

### Auto-Retry on Quote Expiry

When a quote expires during the x402 flow:
1. System automatically creates a new quote
2. Compares new price to original quote
3. If within 5% tolerance, proceeds with new quote
4. Repeats up to 3 times
5. Fails with `QUOTE_RETRY_LIMIT_EXCEEDED` after 3 failed attempts

---

## Order Flow

### Standard Flow

```
1. Create quote (POST /v1/quotes)
   -> Creates soft reservation against available credit
   -> Returns quote_id, payment_requirements

2. Place order (POST /v1/orders with quote_id)
   -> Returns 402 Payment Required with PAYMENT-REQUIRED header

3. Request signature (POST /v1/wallets/x402/sign)
   -> Validates quote binding (amount matches)
   -> Returns signed EIP-3009 authorization

4. Retry order (POST /v1/orders with PAYMENT-SIGNATURE header)
   -> x402 facilitator verifies and settles payment
   -> mUSD transferred to MoltphoMall contract
   -> Procurement task created

5. Order fulfilled
   -> Ops team places Amazon order
   -> Tracking info populated
   -> Status updated to PLACED
```

### Confirmation-Required Mode

When `confirmation_required: true`:

```
1. Create quote
2. Place order
   -> Returns status: PENDING_APPROVAL
3. Owner approves/rejects in portal
   -> Approve: continues to step 4 of standard flow
   -> Reject: order CANCELED, soft reservation released
```

### Cancellation Window

- Orders can be canceled within 5 minutes of PAID status
- After PLACED status, cancellation is not possible (must use returns process)
- Canceled orders receive automatic mUSD balance refund

---

## Refunds

### Refund Types

| Scenario | Refund Target | Timing |
|----------|---------------|--------|
| Immediate procurement failure | mUSD balance | Automatic, instant |
| Ambiguous procurement failure | mUSD balance | 24h staged, then auto |
| Order cancellation (within window) | mUSD balance | Automatic, instant |
| Owner decreases credit limit | Card (via Stripe) | LIFO by funding lot |
| Return/lost package | Manual decision | Support ticket required |

### Staged Refunds

For ambiguous failures (timeout, unclear status):
1. Order enters `PENDING_REVIEW` status
2. 24-hour waiting period for procurement provider clarification
3. Refund amount visible in balance with asterisk notation
4. Auto-refund to mUSD balance if no resolution

**Display:** "$500.00* (Includes $25.00 pending verification)"

### LIFO Refund Order

When owner decreases credit limit, refunds are processed in Last-In-First-Out order:
1. Most recent funding lots refunded first
2. Only unspent portions of lots are refundable
3. Portal explains: "Most recent charges refunded first"
4. Card refunds may take 5-10 business days via Stripe

---

## Agent Status Effects

### DEGRADED Status

**Trigger:** All cards fail during top-up, or owner deletes all payment methods

**Behavior:**
- Agent CAN spend existing credit balance
- Agent CANNOT receive new top-ups
- Agent enters DEGRADED automatically

**Recovery:** Automatic when owner adds valid payment method and next top-up succeeds

### SUSPENDED Status

**Trigger:** Admin action only (fraud, compliance, abuse)

**Behavior:**
- Agent CANNOT place new orders (regardless of balance)
- Existing paid orders continue to fulfillment
- Owner notified via portal

**Recovery:** Owner must resolve issue and explicitly reactivate via portal

---

## Decision Audit Trail

Every autonomous and proactive purchase is logged with:

| Field | Description |
|-------|-------------|
| `decision_reason` | Human-readable "why we bought" explanation |
| `signals_detected` | List of need signals found in conversation |
| `rule_path` | Which rules/checks passed |
| `budget_impact` | Effect on available credit |
| `confidence_tier` | HIGH (>0.9), MEDIUM (0.7-0.9), LOW (<0.7) |

**Example audit entry:**
```json
{
  "order_id": "ord_abc123",
  "decision_reason": "Owner mentioned running out of paper towels",
  "signals_detected": ["explicit_need: 'we're out of'"],
  "rule_path": "proactive_enabled -> low_risk_item -> under_proactive_cap -> confidence_check_passed",
  "budget_impact": {
    "before_cents": 50000,
    "order_cents": 1599,
    "after_cents": 48401
  },
  "confidence_tier": "HIGH",
  "confidence_score": 0.8
}
```

---

## Notifications

All orders trigger portal notifications. Owners are notified for:

| Event | Notification |
|-------|--------------|
| Order placed | Always (portal) |
| Order failed | Always (portal) |
| Proactive order | Always (includes decision reason) |
| Daily cap reached | Always (portal) |
| Refund completed | Always (portal) |

**Note:** Push notifications (email/SMS) are not available in v1. All notifications are portal-only.
