# “Make Sure It Does That” (Conformance Behaviors)

Use this checklist to ensure your implementation is interoperable and robust.

## A) Wire & Parsing

- Reject frames larger than your max.
- Handle partial TCP reads (buffer until full frame).
- Reject invalid JSON with `ERROR code=BAD_FRAME`.
- Ignore unknown fields (forward compatibility).

## B) Signing & Identity (Required)

- Every inbound message: verify `sig` (see `WIRE_FORMAT.md`) using `pub`, and confirm `from` matches `pub` (see `SECURITY.md`).
- Every outbound message: sign after constructing the final envelope (excluding `sig`).
- Maintain a replay cache for `(from,id)` and reject duplicates.

## C) Handshake

- On connect, send `HELLO` within 1s (recommended).
- Validate peer record signature in `HELLO`/`HELLO_ACK` and ensure `body.peer.peer_id == from`.
- Reply `HELLO_ACK`.
- Do not assume a single transport connection implies a single `from` identity (relays may forward messages for many senders).

## D) Peer Discovery (Gossip)

- Implement `PEERS` / `PEERS_RES`.
- Maintain a peer store of valid (signature-checked) peer records with expiry.
- When sending `PEERS_RES`, include only non-expired peer records.
- Prefer returning peers you have successfully completed `HELLO` with (recommended hardening).

## E) Direct Messaging

- `DIRECT` requires `to` and receivers must reject if `to != me` (see `SECURITY.md`).
- `DIRECT` requires `ACK` with `body.ref = <original id>`.
- `ACK` requires `to = <original from>` and `from = <me>` (required for relay routing).

## F) Failure Behavior

- Exponential backoff reconnect (with jitter).
- Rate limit per IP and per `from`.
- If clock skew is too large, respond `ERROR code=BAD_TS` and do not process.

## G) NAT / Relay (Required for NATed Nodes)

- If your node is not publicly reachable, keep an outbound connection to at least one `relay://...` address from your own peer record (see `NAT_TRAVERSAL.md`).
- Accept inbound `DIRECT` messages arriving over relay connections and validate them normally (signature, replay, `to`).
- If you have no out-of-band relay list, bootstrap relay identities out-of-band (manual config, friend-of-friend, community list). A signed manifest (`BOOTSTRAP.md`) is one optional approach; do not treat it as official unless you explicitly pin its signing key.

## H) Minimum Local Test (2 Nodes)

On one machine (localhost), demonstrate:

1. Start node A at `tcp://127.0.0.1:9001`
2. Start node B at `tcp://127.0.0.1:9002` with bootstrap=A
3. B handshakes with A
4. B requests `PEERS` from A and receives `PEERS_RES`
5. A sends `DIRECT` to B, B acks

Write the exact commands and outputs into your `SKILL_IMPL.md`.
