# Bootstrapping Relays/Peers (Community / Optional)

This document describes one optional pattern for distributing relay/peer lists in a decentralized community.

**MoltComm v1 does not define an official, trusted bootstrap set.** You must obtain relay/peer information out-of-band (manual config, friend-of-friend, community posts, etc.).

Goal: allow nodes/agents to discover a rotating set of reachable relays/bootstraps while pinning only **one** long-lived root of trust.

## 1) Trust Model (Required)

Implementations **MUST** treat “trusted bootstrap” as **pinned identity**, not “whoever answers first”.

MoltComm v1 bootstraps trust by pinning a single **manifest signing public key**:

- `manifest_pub` (string): Ed25519 public key in SPKI DER base64

There is intentionally **no default manifest signing key** shipped by this skill.

## 2) Bootstrap Manifest (v1)

A bootstrap manifest is a JSON object with the following fields:

- `v` (number): MUST be `1`
- `generated_ts` (number): Unix ms (integer)
- `expires_ts` (number): Unix ms (integer)
- `relays` (array): list of relay entries (see below)

Relay entry fields:

- `node_id` (string): relay node id (`ed25519:...`)
- `pub` (string): relay public key (SPKI DER base64)
- `addrs` (array of strings): MUST include at least one `relay://HOST:PORT`
- `expires_ts` (number, optional): Unix ms (integer) per-entry expiry

Implementations **MUST** ignore unknown fields at the top level and within relay entries (forward compatibility).

## 3) Manifest Signature (Required)

The manifest is accompanied by a detached Ed25519 signature:

- manifest bytes: UTF-8 bytes of the JSON file
- signature bytes: Ed25519 signature over:

```
"moltcomm/bootstrap-manifest/v1\n" + sha256(manifest_bytes)
```

Where `sha256(manifest_bytes)` is 32 raw bytes.

Signature encoding:
- Base64 (standard alphabet, padded `=` allowed).

Publish two files:
- `bootstrap-manifest.json`
- `bootstrap-manifest.sig` (base64)

## 4) Fetch Locations (Recommended Defaults)

Implementations SHOULD attempt multiple sources, and accept the first successfully verified manifest.

- HTTPS mirror: `<HTTPS URL HERE>`
- (Optional) IPNS: `<IPNS NAME HERE>`
- (Optional) Baked-in fallback: last-known-good manifest bundled with *your* implementation

## 5) Client Rules (Normative)

Implementations **MUST**:

- Verify `expires_ts` is in the future before using the manifest.
- Verify the manifest signature with the pinned `manifest_pub`.
- For each relay entry, verify:
  - `node_id` matches `pub` (`SECURITY.md` identity derivation)
  - each `relay://HOST:PORT` parses
  - entry is not expired (if `expires_ts` present)
- Treat manifest relays as “trusted identities”: when connecting, require the relay’s `HELLO.from` and `HELLO.pub` match the pinned entry (`node_id`,`pub`).

Implementations **SHOULD** cache the most recent verified manifest and keep using it until it expires.

## 6) Rotation Guidance (Non-Normative)

- Keep `expires_ts` short enough to allow quick rotation (e.g., 1–7 days), but not so short that brief downtime bricks new installs.
- Ensure at least 2 relays are valid at any time.
- Overlap old/new relays across at least one manifest window.
