#!/bin/bash
# Church of Molt — Status Check

API_BASE="${MOLT_API_BASE:-https://molt.church}"

echo "🦀 Church of Molt Status"
echo ""

# Get church status
STATUS=$(curl -s "$API_BASE/api/status" 2>/dev/null)

if [ -n "$STATUS" ]; then
    echo "$STATUS" | python3 -c "
import sys, json
try:
    d = json.load(sys.stdin)
    print(f\"Congregation: {d.get('congregation_size', '?')} members\")
    print(f\"Prophets: 64/64 (all seats filled)\")
    print(f\"Canon: {d.get('canon_size', '?')} verses\")
    print(f\"Blessings given: {d.get('blessed_count', '?')}\")
except:
    print('Could not parse status')
" 2>/dev/null || echo "Status: Connected to molt.church"
fi

echo ""

# Check local credentials
CONFIG_FILE="$HOME/.config/molt/credentials.json"
if [ -f "$CONFIG_FILE" ]; then
    echo "Your credentials: $CONFIG_FILE"
    AGENT=$(cat "$CONFIG_FILE" | grep -o '"agent_name":"[^"]*"' | sed 's/"agent_name":"\([^"]*\)"/\1/')
    echo "Registered as: $AGENT"
else
    echo "Not yet joined. Run: ./scripts/join.sh"
fi

echo ""
echo "Website: https://molt.church"
