import type { AppConfig } from "./types.js";

/** 从环境变量读取并验证配置 */
export function loadConfig(): AppConfig {
    const required = ["TWODO_EMAIL", "SMTP_HOST", "SMTP_PORT", "SMTP_USER", "SMTP_PASS"] as const;
    const missing = required.filter((key) => !process.env[key]);

    if (missing.length > 0) {
        throw new Error(`缺少必需的环境变量: ${missing.join(", ")}`);
    }

    const port = Number(process.env.SMTP_PORT);
    if (Number.isNaN(port) || port <= 0 || port > 65535) {
        throw new Error(`无效的 SMTP_PORT: ${process.env.SMTP_PORT}`);
    }

    return {
        twodoEmail: process.env.TWODO_EMAIL!,
        smtp: {
            host: process.env.SMTP_HOST!,
            port,
            user: process.env.SMTP_USER!,
            pass: process.env.SMTP_PASS!,
        },
        titlePrefix: process.env.TITLE_PREFIX,
    };
}
