#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_DIR="$(dirname "$SCRIPT_DIR")"

# 优先使用编译产物，否则回退到 tsx 开发模式
if [ -f "$PROJECT_DIR/dist/main.js" ]; then
    node "$PROJECT_DIR/dist/main.js" "$@"
else
    npx --prefix "$PROJECT_DIR" tsx "$PROJECT_DIR/src/main.ts" "$@"
fi
